/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveOrphanFilesProcedure
extends BaseProcedure {
    private static final Logger LOG = LoggerFactory.getLogger((String)RemoveOrphanFilesProcedure.class.getName());
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("older_than", DataTypes.StringType), ProcedureParameter.optional("dry_run", DataTypes.BooleanType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata.empty())});

    private RemoveOrphanFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        boolean dryRun;
        String olderThan;
        List<OrphanFilesClean> tableCleans;
        String tableId = args.getString(0);
        Preconditions.checkArgument(tableId != null && !tableId.isEmpty(), "Cannot handle an empty tableId for argument %s", tableId);
        Identifier identifier = tableId.endsWith(".*") ? Identifier.fromString(tableId) : Identifier.fromString(this.toIdentifier(args.getString(0), PARAMETERS[0].name()).toString());
        LOG.info("identifier is {}.", (Object)identifier);
        try {
            tableCleans = OrphanFilesClean.createOrphanFilesCleans(((WithPaimonCatalog)this.tableCatalog()).paimonCatalog(), identifier.getDatabaseName(), identifier.getObjectName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String string = olderThan = args.isNullAt(1) ? null : args.getString(1);
        if (!StringUtils.isBlank(olderThan)) {
            tableCleans.forEach(clean -> clean.olderThan(olderThan));
        }
        boolean bl = dryRun = !args.isNullAt(2) && args.getBoolean(2);
        if (dryRun) {
            tableCleans.forEach(clean -> clean.fileCleaner(path -> {}));
        }
        String[] result = OrphanFilesClean.executeOrphanFilesClean(tableCleans);
        ArrayList rows = new ArrayList();
        Arrays.stream(result).forEach(line -> rows.add(this.newInternalRow(UTF8String.fromString((String)line))));
        return rows.toArray(new InternalRow[0]);
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RemoveOrphanFilesProcedure>(){

            @Override
            public RemoveOrphanFilesProcedure doBuild() {
                return new RemoveOrphanFilesProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RemoveOrphanFilesProcedure";
    }
}

