/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.utils;

import java.util.Map;
import org.apache.paimon.catalog.CachingCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.migrate.HiveMigrator;
import org.apache.paimon.migrate.Migrator;

public class TableMigrationUtils {
    public static Migrator getImporter(String connector, Catalog catalog, String sourceDatabase, String sourceTableName, String targetDatabase, String targetTableName, Map<String, String> options) {
        switch (connector) {
            case "hive": {
                if (catalog instanceof CachingCatalog) {
                    catalog = ((CachingCatalog)catalog).wrapped();
                }
                if (!(catalog instanceof HiveCatalog)) {
                    throw new IllegalArgumentException("Only support Hive Catalog");
                }
                return new HiveMigrator((HiveCatalog)catalog, sourceDatabase, sourceTableName, targetDatabase, targetTableName, options);
            }
        }
        throw new UnsupportedOperationException("Unsupported connector " + connector);
    }
}

