/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class BitmapFileIndexMeta {
    private final DataType dataType;
    private int rowCount;
    private int nonNullBitmapNumber;
    private boolean hasNullValue;
    private int nullValueOffset;
    private LinkedHashMap<Object, Integer> bitmapOffsets;

    public BitmapFileIndexMeta(DataType dataType) {
        this.dataType = dataType;
    }

    public BitmapFileIndexMeta(DataType dataType, int rowCount, int nonNullBitmapNumber, boolean hasNullValue, int nullValueOffset, LinkedHashMap<Object, Integer> bitmapOffsets) {
        this(dataType);
        this.rowCount = rowCount;
        this.nonNullBitmapNumber = nonNullBitmapNumber;
        this.hasNullValue = hasNullValue;
        this.nullValueOffset = nullValueOffset;
        this.bitmapOffsets = bitmapOffsets;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean contains(Object bitmapId) {
        if (bitmapId == null) {
            return this.hasNullValue;
        }
        return this.bitmapOffsets.containsKey(bitmapId);
    }

    public int getOffset(Object bitmapId) {
        if (bitmapId == null) {
            return this.nullValueOffset;
        }
        return this.bitmapOffsets.get(bitmapId);
    }

    public void serialize(final DataOutput out) throws Exception {
        ThrowableConsumer valueWriter = this.dataType.accept(new DataTypeVisitorAdapter<ThrowableConsumer>(){

            @Override
            public ThrowableConsumer visitBinaryString() {
                return o -> {
                    byte[] bytes = ((BinaryString)o).toBytes();
                    out.writeInt(bytes.length);
                    out.write(bytes);
                };
            }

            @Override
            public ThrowableConsumer visitByte() {
                return o -> out.writeByte(((Byte)o).byteValue());
            }

            @Override
            public ThrowableConsumer visitShort() {
                return o -> out.writeShort(((Short)o).shortValue());
            }

            @Override
            public ThrowableConsumer visitInt() {
                return o -> out.writeInt((Integer)o);
            }

            @Override
            public ThrowableConsumer visitLong() {
                return o -> out.writeLong((Long)o);
            }

            @Override
            public ThrowableConsumer visitFloat() {
                return o -> out.writeFloat(((Float)o).floatValue());
            }

            @Override
            public ThrowableConsumer visitDouble() {
                return o -> out.writeDouble((Double)o);
            }
        });
        out.writeInt(this.rowCount);
        out.writeInt(this.nonNullBitmapNumber);
        out.writeBoolean(this.hasNullValue);
        if (this.hasNullValue) {
            out.writeInt(this.nullValueOffset);
        }
        for (Map.Entry<Object, Integer> entry : this.bitmapOffsets.entrySet()) {
            valueWriter.accept(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    public void deserialize(final DataInput in) throws Exception {
        ThrowableSupplier valueReader = this.dataType.accept(new DataTypeVisitorAdapter<ThrowableSupplier>(){

            @Override
            public ThrowableSupplier visitBinaryString() {
                return () -> {
                    int length = in.readInt();
                    byte[] bytes = new byte[length];
                    in.readFully(bytes);
                    return BinaryString.fromBytes(bytes);
                };
            }

            @Override
            public ThrowableSupplier visitByte() {
                return in::readByte;
            }

            @Override
            public ThrowableSupplier visitShort() {
                return in::readShort;
            }

            @Override
            public ThrowableSupplier visitInt() {
                return in::readInt;
            }

            @Override
            public ThrowableSupplier visitLong() {
                return in::readLong;
            }

            @Override
            public ThrowableSupplier visitFloat() {
                return in::readFloat;
            }

            @Override
            public ThrowableSupplier visitDouble() {
                return in::readDouble;
            }
        });
        this.rowCount = in.readInt();
        this.nonNullBitmapNumber = in.readInt();
        this.hasNullValue = in.readBoolean();
        if (this.hasNullValue) {
            this.nullValueOffset = in.readInt();
        }
        this.bitmapOffsets = new LinkedHashMap();
        for (int i = 0; i < this.nonNullBitmapNumber; ++i) {
            this.bitmapOffsets.put(valueReader.get(), in.readInt());
        }
    }

    public static abstract class DataTypeVisitorAdapter<R>
    implements DataTypeVisitor<R> {
        public abstract R visitBinaryString();

        public abstract R visitByte();

        public abstract R visitShort();

        public abstract R visitInt();

        public abstract R visitLong();

        public abstract R visitFloat();

        public abstract R visitDouble();

        @Override
        public final R visit(CharType charType) {
            return this.visitBinaryString();
        }

        @Override
        public final R visit(VarCharType varCharType) {
            return this.visitBinaryString();
        }

        @Override
        public final R visit(BooleanType booleanType) {
            return this.visitByte();
        }

        @Override
        public final R visit(BinaryType binaryType) {
            throw new UnsupportedOperationException("Does not support type binary");
        }

        @Override
        public final R visit(VarBinaryType varBinaryType) {
            throw new UnsupportedOperationException("Does not support type binary");
        }

        @Override
        public final R visit(DecimalType decimalType) {
            throw new UnsupportedOperationException("Does not support decimal");
        }

        @Override
        public final R visit(TinyIntType tinyIntType) {
            return this.visitByte();
        }

        @Override
        public final R visit(SmallIntType smallIntType) {
            return this.visitShort();
        }

        @Override
        public final R visit(IntType intType) {
            return this.visitInt();
        }

        @Override
        public final R visit(BigIntType bigIntType) {
            return this.visitLong();
        }

        @Override
        public final R visit(FloatType floatType) {
            return this.visitFloat();
        }

        @Override
        public final R visit(DoubleType doubleType) {
            return this.visitDouble();
        }

        @Override
        public final R visit(DateType dateType) {
            return this.visitInt();
        }

        @Override
        public final R visit(TimeType timeType) {
            return this.visitInt();
        }

        @Override
        public final R visit(ArrayType arrayType) {
            throw new UnsupportedOperationException("Does not support type array");
        }

        @Override
        public final R visit(MultisetType multisetType) {
            throw new UnsupportedOperationException("Does not support type mutiset");
        }

        @Override
        public final R visit(TimestampType timestampType) {
            return this.visitLong();
        }

        @Override
        public final R visit(LocalZonedTimestampType localZonedTimestampType) {
            return this.visitLong();
        }

        @Override
        public final R visit(MapType mapType) {
            throw new UnsupportedOperationException("Does not support type map");
        }

        @Override
        public final R visit(RowType rowType) {
            throw new UnsupportedOperationException("Does not support type row");
        }
    }

    public static interface ThrowableSupplier {
        public Object get() throws Exception;
    }

    public static interface ThrowableConsumer {
        public void accept(Object var1) throws Exception;
    }
}

