/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.spark.DataConverter;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.TypeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.SupportsAtomicPartitionManagement;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0003\u0006\f!\u0003\r\t\u0001F?\t\u000b!\u0002A\u0011A\u0015\t\u0011A\u0002\u0001R1A\u0005\nEB\u0001\u0002\u000f\u0001\t\u0006\u0004%\t%\u000f\u0005\u0006\u007f\u0001!I\u0001\u0011\u0005\u0006=\u0002!\te\u0018\u0005\u0006I\u0002!\t%\u001a\u0005\u0006[\u0002!\tE\u001c\u0005\u0006a\u0002!\t%\u001d\u0005\u0006o\u0002!\t\u0005\u001f\u0002\u001a!\u0006LWn\u001c8QCJ$\u0018\u000e^5p]6\u000bg.Y4f[\u0016tGO\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007a\u0006LWn\u001c8\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Q#\b\t\u0003-mi\u0011a\u0006\u0006\u00031e\tA\u0001\\1oO*\t!$\u0001\u0003kCZ\f\u0017B\u0001\u000f\u0018\u0005\u0019y%M[3diB\u0011aDJ\u0007\u0002?)\u0011\u0001%I\u0001\bG\u0006$\u0018\r\\8h\u0015\t\u00113%A\u0005d_:tWm\u0019;pe*\u0011A%J\u0001\u0004gFd'B\u0001\u0007\u0010\u0013\t9sDA\u0011TkB\u0004xN\u001d;t\u0003R|W.[2QCJ$\u0018\u000e^5p]6\u000bg.Y4f[\u0016tG/\u0001\u0004%S:LG\u000f\n\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5u\u0003A\u0001\u0018M\u001d;ji&|gNU8x)f\u0004X-F\u00013!\t\u0019d'D\u00015\u0015\t)T\"A\u0003usB,7/\u0003\u00028i\t9!k\\<UsB,\u0017a\u00049beRLG/[8o'\u000eDW-\\1\u0016\u0003i\u0002\"aO\u001f\u000e\u0003qR!!N\u0012\n\u0005yb$AC*ueV\u001cG\u000fV=qK\u0006\u0011Bo\u001c)bS6|g\u000eU1si&$\u0018n\u001c8t)\t\tU\u000bE\u0002,\u0005\u0012K!a\u0011\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0015C%JS\u0007\u0002\r*\u0011q)G\u0001\u0005kRLG.\u0003\u0002J\r\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"a\u0013*\u000f\u00051\u0003\u0006CA'-\u001b\u0005q%BA(\u0014\u0003\u0019a$o\\8u}%\u0011\u0011\u000bL\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002RY!)a\u000b\u0002a\u0001/\u0006!!o\\<t!\rY#\t\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\u000e\n\u0001bY1uC2L8\u000f^\u0005\u0003;j\u00131\"\u00138uKJt\u0017\r\u001c*po\u0006qAM]8q!\u0006\u0014H/\u001b;j_:\u001cHC\u00011d!\tY\u0013-\u0003\u0002cY\t9!i\\8mK\u0006t\u0007\"\u0002,\u0006\u0001\u00049\u0016\u0001\u0007:fa2\f7-\u001a)beRLG/[8o\u001b\u0016$\u0018\rZ1uCR\u0019!F\u001a5\t\u000b\u001d4\u0001\u0019\u0001-\u0002\u000b%$WM\u001c;\t\u000b%4\u0001\u0019\u00016\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003FW*S\u0015B\u00017G\u0005\ri\u0015\r]\u0001\u0016Y>\fG\rU1si&$\u0018n\u001c8NKR\fG-\u0019;b)\tQw\u000eC\u0003h\u000f\u0001\u0007\u0001,\u0001\rmSN$\b+\u0019:uSRLwN\\%eK:$\u0018NZ5feN$2a\u0016:v\u0011\u0015\u0019\b\u00021\u0001u\u00035\u0001\u0018M\u001d;ji&|gnQ8mgB\u00191F\u0011&\t\u000bYD\u0001\u0019\u0001-\u0002\u0017%tG/\u001a:oC2\u0014vn^\u0001\u0011GJ,\u0017\r^3QCJ$\u0018\u000e^5p]N$2AK={\u0011\u00151\u0016\u00021\u0001X\u0011\u0015Y\u0018\u00021\u0001}\u0003\u0011i\u0017\r]:\u0011\u0007-\u0012%\u000e\u0005\u0002\u007f\u007f6\t1\"C\u0002\u0002\u0002-\u0011!b\u00159be.$\u0016M\u00197f\u0001")
public interface PaimonPartitionManagement
extends SupportsAtomicPartitionManagement {
    public static /* synthetic */ RowType org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType$(PaimonPartitionManagement $this) {
        return $this.org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType();
    }

    default public RowType org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType() {
        return TypeUtils.project(((SparkTable)this).table().rowType(), ((SparkTable)this).table().partitionKeys());
    }

    public static /* synthetic */ StructType partitionSchema$(PaimonPartitionManagement $this) {
        return $this.partitionSchema();
    }

    default public StructType partitionSchema() {
        return SparkTypeUtils.fromPaimonRowType(this.org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType());
    }

    private LinkedHashMap<String, String>[] toPaimonPartitions(InternalRow[] rows) {
        Table table = ((SparkTable)this).table();
        if (!(table instanceof FileStoreTable)) {
            throw new UnsupportedOperationException("Only FileStoreTable supports partitions.");
        }
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        Function1 rowConverter = CatalystTypeConverters$.MODULE$.createToScalaConverter(CharVarcharUtils$.MODULE$.replaceCharVarcharWithString((DataType)this.partitionSchema()));
        InternalRowPartitionComputer rowDataPartitionComputer = new InternalRowPartitionComputer(fileStoreTable.coreOptions().partitionDefaultName(), this.org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType(), (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SparkTable)this).table().partitionKeys()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), CoreOptions.fromMap(((SparkTable)this).table().options()).legacyPartitionName());
        LinkedHashMap[] linkedHashMapArray = (LinkedHashMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).map((Function1 & Serializable & scala.Serializable)r -> rowDataPartitionComputer.generatePartValues(new SparkRow(this.org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType(), (Row)rowConverter.apply(r))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LinkedHashMap.class)));
        return linkedHashMapArray;
    }

    public static /* synthetic */ boolean dropPartitions$(PaimonPartitionManagement $this, InternalRow[] rows) {
        return $this.dropPartitions(rows);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean dropPartitions(InternalRow[] rows) {
        Table table = ((SparkTable)this).table();
        if (!(table instanceof FileStoreTable)) throw new UnsupportedOperationException("Only FileStoreTable supports drop partitions.");
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        java.util.Map[] partitions = (java.util.Map[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.toPaimonPartitions(rows))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.util.Map.class)));
        FileStoreCommit commit = fileStoreTable.store().newCommit(UUID.randomUUID().toString());
        AutoCloseable metastoreClient = null;
        MetastoreClient.Factory clientFactory = fileStoreTable.catalogEnvironment().metastoreClientFactory();
        try {
            commit.dropPartitions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).toSeq()).asJava(), Long.MAX_VALUE);
            if (clientFactory == null) return true;
            if (!fileStoreTable.coreOptions().partitionedTableInMetastore()) return true;
            metastoreClient = clientFactory.create();
            metastoreClient.dropPartitions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.toPaimonPartitions(rows))).toSeq()).asJava());
            return true;
        }
        finally {
            commit.close();
            if (metastoreClient != null) {
                metastoreClient.close();
            }
        }
    }

    public static /* synthetic */ void replacePartitionMetadata$(PaimonPartitionManagement $this, InternalRow ident, java.util.Map properties) {
        $this.replacePartitionMetadata(ident, properties);
    }

    default public void replacePartitionMetadata(InternalRow ident, java.util.Map<String, String> properties) {
        throw new UnsupportedOperationException("Replace partition is not supported");
    }

    public static /* synthetic */ java.util.Map loadPartitionMetadata$(PaimonPartitionManagement $this, InternalRow ident) {
        return $this.loadPartitionMetadata(ident);
    }

    default public java.util.Map<String, String> loadPartitionMetadata(InternalRow ident) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
    }

    public static /* synthetic */ InternalRow[] listPartitionIdentifiers$(PaimonPartitionManagement $this, String[] partitionCols, InternalRow internalRow) {
        return $this.listPartitionIdentifiers(partitionCols, internalRow);
    }

    default public InternalRow[] listPartitionIdentifiers(String[] partitionCols, InternalRow internalRow) {
        Predef$.MODULE$.assert(partitionCols.length == internalRow.numFields(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Number of partition names (").append(partitionCols.length).append(") must be equal to ").append("the number of partition values (").append(internalRow.numFields()).append(").").toString());
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionCols)).forall((Function1 & Serializable & scala.Serializable)fieldName -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$2(this, fieldName))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Some partition names ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionCols)).mkString("[", ", ", "]")).append(" don't belong to ").append("the partition schema '").append(this.partitionSchema().sql()).append("'.").toString());
        return (InternalRow[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((SparkTable)this).table().newReadBuilder().newScan().listPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)binaryRow -> DataConverter.fromPaimon(binaryRow, this.org$apache$paimon$spark$PaimonPartitionManagement$$partitionRowType()), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)sparkInternalRow -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$5(this, partitionCols, internalRow, sparkInternalRow)))).toArray(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public static /* synthetic */ void createPartitions$(PaimonPartitionManagement $this, InternalRow[] rows, java.util.Map[] maps) {
        $this.createPartitions(rows, maps);
    }

    default public void createPartitions(InternalRow[] rows, java.util.Map<String, String>[] maps) {
        BoxedUnit boxedUnit;
        Table table = ((SparkTable)this).table();
        if (table instanceof FileStoreTable) {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            LinkedHashMap<String, String>[] partitions = this.toPaimonPartitions(rows);
            MetastoreClient.Factory metastoreFactory = fileStoreTable.catalogEnvironment().metastoreClientFactory();
            if (metastoreFactory == null) {
                throw new UnsupportedOperationException("The table must have metastore to create partition.");
            }
            try (MetastoreClient metastoreClient = metastoreFactory.create();){
                if (fileStoreTable.coreOptions().partitionedTableInMetastore()) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        metastoreClient.addPartition(x$1);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new UnsupportedOperationException("Only FileStoreTable supports create partitions.");
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$2(PaimonPartitionManagement $this, String fieldName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionSchema().fieldNames())).contains((Object)fieldName);
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$6(PaimonPartitionManagement $this, InternalRow sparkInternalRow$1, InternalRow internalRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String partitionName = (String)tuple2._1();
        int index = tuple2._2$mcI$sp();
        int internalRowIndex = $this.partitionSchema().fieldIndex(partitionName);
        StructField structField = $this.partitionSchema().fields()[internalRowIndex];
        boolean bl = Objects.equals(sparkInternalRow$1.get(internalRowIndex, structField.dataType()), internalRow$1.get(index, structField.dataType()));
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$7(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$5(PaimonPartitionManagement $this, String[] partitionCols$1, InternalRow internalRow$1, InternalRow sparkInternalRow) {
        return new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionCols$1)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$6($this, sparkInternalRow, internalRow$1, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$7(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public static void $init$(PaimonPartitionManagement $this) {
    }
}

