/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.TableType;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.spark.SparkCatalogOptions;
import org.apache.paimon.spark.SparkSource;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.catalog.SparkBaseCatalog;
import org.apache.paimon.spark.catalog.SupportFunction;
import org.apache.paimon.spark.catalog.SupportView;
import org.apache.paimon.spark.util.OptionUtils;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.FormatTableOptions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVTable;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcTable;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetTable;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;

public class SparkCatalog
extends SparkBaseCatalog
implements SupportFunction,
SupportView {
    private static final Logger LOG = LoggerFactory.getLogger(SparkCatalog.class);
    private static final String PRIMARY_KEY_IDENTIFIER = "primary-key";
    protected Catalog catalog = null;
    private String defaultDatabase;

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.catalogName = name;
        CatalogContext catalogContext = CatalogContext.create(Options.fromMap((Map<String, String>)options), SparkSession.active().sessionState().newHadoopConf());
        this.catalog = CatalogFactory.createCatalog(catalogContext);
        this.defaultDatabase = (String)options.getOrDefault((Object)SparkCatalogOptions.DEFAULT_DATABASE.key(), (Object)SparkCatalogOptions.DEFAULT_DATABASE.defaultValue());
        try {
            this.catalog.getDatabase(this.defaultNamespace()[0]);
        }
        catch (Catalog.DatabaseNotExistException e) {
            try {
                this.createNamespace(this.defaultNamespace(), new HashMap<String, String>());
            }
            catch (NamespaceAlreadyExistsException namespaceAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public Catalog paimonCatalog() {
        return this.catalog;
    }

    public String[] defaultNamespace() {
        return new String[]{this.defaultDatabase};
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            this.catalog.createDatabase(databaseName, false, metadata);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new NamespaceAlreadyExistsException(namespace);
        }
    }

    public String[][] listNamespaces() {
        List<String> databases = this.catalog.listDatabases();
        String[][] namespaces = new String[databases.size()][];
        for (int i = 0; i < databases.size(); ++i) {
            namespaces[i] = new String[]{databases.get(i)};
        }
        return namespaces;
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        if (namespace.length == 0) {
            return this.listNamespaces();
        }
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            this.catalog.getDatabase(databaseName);
            return new String[0][];
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            return this.catalog.getDatabase(databaseName).options();
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public boolean dropNamespace(String[] namespace) throws NoSuchNamespaceException {
        return this.dropNamespace(namespace, false);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            this.catalog.dropDatabase(databaseName, false, cascade);
            return true;
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new UnsupportedOperationException(String.format("Namespace %s is not empty", Arrays.toString(namespace)));
        }
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            return (Identifier[])this.catalog.listTables(databaseName).stream().map(table -> Identifier.of((String[])namespace, (String)table)).toArray(Identifier[]::new);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public void invalidateTable(Identifier ident) {
        this.catalog.invalidateTable(CatalogUtils.toIdentifier(ident));
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        return this.loadSparkTable(ident, Collections.emptyMap());
    }

    public SparkTable loadTable(Identifier ident, String version) throws NoSuchTableException {
        LOG.info("Time travel to version '{}'.", (Object)version);
        Table table = this.loadSparkTable(ident, Collections.singletonMap(CoreOptions.SCAN_VERSION.key(), version));
        if (table instanceof SparkTable) {
            return (SparkTable)table;
        }
        throw new NoSuchTableException(ident);
    }

    public SparkTable loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        LOG.info("Time travel target timestamp is {} milliseconds.", (Object)(timestamp /= 1000L));
        Table table = this.loadSparkTable(ident, Collections.singletonMap(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), String.valueOf(timestamp)));
        if (table instanceof SparkTable) {
            return (SparkTable)table;
        }
        throw new NoSuchTableException(ident);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        List<SchemaChange> schemaChanges = Arrays.stream(changes).map(this::toSchemaChange).collect(Collectors.toList());
        try {
            this.catalog.alterTable(CatalogUtils.toIdentifier(ident), schemaChanges, false);
            return this.loadTable(ident);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(ident);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        try {
            this.catalog.createTable(CatalogUtils.toIdentifier(ident), this.toInitialSchema(schema, partitions, properties), false);
            return this.loadTable(ident);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException(ident);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(ident.namespace());
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropTable(Identifier ident) {
        try {
            this.catalog.dropTable(CatalogUtils.toIdentifier(ident), false);
            return true;
        }
        catch (Catalog.TableNotExistException e) {
            return false;
        }
    }

    private SchemaChange toSchemaChange(TableChange change) {
        if (change instanceof TableChange.SetProperty) {
            TableChange.SetProperty set = (TableChange.SetProperty)change;
            this.validateAlterProperty(set.property());
            if (set.property().equals("comment")) {
                return SchemaChange.updateComment(set.value());
            }
            return SchemaChange.setOption(set.property(), set.value());
        }
        if (change instanceof TableChange.RemoveProperty) {
            TableChange.RemoveProperty remove = (TableChange.RemoveProperty)change;
            this.validateAlterProperty(remove.property());
            if (remove.property().equals("comment")) {
                return SchemaChange.updateComment(null);
            }
            return SchemaChange.removeOption(remove.property());
        }
        if (change instanceof TableChange.AddColumn) {
            TableChange.AddColumn add = (TableChange.AddColumn)change;
            SchemaChange.Move move = SparkCatalog.getMove(add.position(), add.fieldNames());
            return SchemaChange.addColumn(add.fieldNames(), SparkTypeUtils.toPaimonType(add.dataType()).copy(add.isNullable()), add.comment(), move);
        }
        if (change instanceof TableChange.RenameColumn) {
            TableChange.RenameColumn rename = (TableChange.RenameColumn)change;
            return SchemaChange.renameColumn(rename.fieldNames(), rename.newName());
        }
        if (change instanceof TableChange.DeleteColumn) {
            TableChange.DeleteColumn delete = (TableChange.DeleteColumn)change;
            return SchemaChange.dropColumn(delete.fieldNames());
        }
        if (change instanceof TableChange.UpdateColumnType) {
            TableChange.UpdateColumnType update = (TableChange.UpdateColumnType)change;
            return SchemaChange.updateColumnType(update.fieldNames(), SparkTypeUtils.toPaimonType(update.newDataType()), true);
        }
        if (change instanceof TableChange.UpdateColumnNullability) {
            TableChange.UpdateColumnNullability update = (TableChange.UpdateColumnNullability)change;
            return SchemaChange.updateColumnNullability(update.fieldNames(), update.nullable());
        }
        if (change instanceof TableChange.UpdateColumnComment) {
            TableChange.UpdateColumnComment update = (TableChange.UpdateColumnComment)change;
            return SchemaChange.updateColumnComment(update.fieldNames(), update.newComment());
        }
        if (change instanceof TableChange.UpdateColumnPosition) {
            TableChange.UpdateColumnPosition update = (TableChange.UpdateColumnPosition)change;
            SchemaChange.Move move = SparkCatalog.getMove(update.position(), update.fieldNames());
            return SchemaChange.updateColumnPosition(move);
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    private static SchemaChange.Move getMove(TableChange.ColumnPosition columnPosition, String[] fieldNames) {
        SchemaChange.Move move = null;
        if (columnPosition instanceof TableChange.First) {
            move = SchemaChange.Move.first(fieldNames[0]);
        } else if (columnPosition instanceof TableChange.After) {
            move = SchemaChange.Move.after(fieldNames[0], ((TableChange.After)columnPosition).column());
        }
        return move;
    }

    private Schema toInitialSchema(StructType schema, Transform[] partitions, Map<String, String> properties) {
        String pkAsString;
        HashMap<String, String> normalizedProperties = new HashMap<String, String>(properties);
        String provider = properties.get("provider");
        if (!this.usePaimon(provider) && SparkSource.FORMAT_NAMES().contains((Object)provider.toLowerCase())) {
            normalizedProperties.put(CoreOptions.TYPE.key(), TableType.FORMAT_TABLE.toString());
            normalizedProperties.put(CoreOptions.FILE_FORMAT.key(), provider.toLowerCase());
        }
        normalizedProperties.remove("provider");
        normalizedProperties.remove(PRIMARY_KEY_IDENTIFIER);
        normalizedProperties.remove("comment");
        if (normalizedProperties.containsKey("location")) {
            String path = (String)normalizedProperties.remove("location");
            normalizedProperties.put(CoreOptions.PATH.key(), path);
        }
        List<String> primaryKeys = (pkAsString = properties.get(PRIMARY_KEY_IDENTIFIER)) == null ? Collections.emptyList() : Arrays.stream(pkAsString.split(",")).map(String::trim).collect(Collectors.toList());
        Schema.Builder schemaBuilder = Schema.newBuilder().options(normalizedProperties).primaryKey(primaryKeys).partitionKeys(this.convertPartitionTransforms(partitions)).comment(properties.getOrDefault("comment", null));
        for (StructField field : schema.fields()) {
            schemaBuilder.column(field.name(), SparkTypeUtils.toPaimonType(field.dataType()).copy(field.nullable()), (String)field.getComment().getOrElse(() -> null));
        }
        return schemaBuilder.build();
    }

    private void validateAlterProperty(String alterKey) {
        if (PRIMARY_KEY_IDENTIFIER.equals(alterKey)) {
            throw new UnsupportedOperationException("Alter primary key is not supported");
        }
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        try {
            this.catalog.renameTable(CatalogUtils.toIdentifier(oldIdent), CatalogUtils.toIdentifier(newIdent), false);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(oldIdent);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException(newIdent);
        }
    }

    protected Table loadSparkTable(Identifier ident, Map<String, String> extraOptions) throws NoSuchTableException {
        try {
            org.apache.paimon.table.Table paimonTable = this.catalog.getTable(CatalogUtils.toIdentifier(ident));
            if (paimonTable instanceof FormatTable) {
                return SparkCatalog.convertToFileTable(ident, (FormatTable)paimonTable);
            }
            return new SparkTable(OptionUtils.copyWithSQLConf(paimonTable, this.catalogName, CatalogUtils.toIdentifier(ident), extraOptions));
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(ident);
        }
    }

    private static FileTable convertToFileTable(Identifier ident, FormatTable formatTable) {
        StructType schema = SparkTypeUtils.fromPaimonRowType(formatTable.rowType());
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(formatTable.location());
        Options options = Options.fromMap(formatTable.options());
        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(options.toMap());
        if (formatTable.format() == FormatTable.Format.CSV) {
            options.set("sep", options.get(FormatTableOptions.FIELD_DELIMITER));
            dsOptions = new CaseInsensitiveStringMap(options.toMap());
            return new CSVTable(ident.name(), SparkSession.active(), dsOptions, JavaConverters.asScalaBuffer(pathList).toSeq(), Option.apply((Object)schema), CSVFileFormat.class);
        }
        if (formatTable.format() == FormatTable.Format.ORC) {
            return new OrcTable(ident.name(), SparkSession.active(), dsOptions, JavaConverters.asScalaBuffer(pathList).toSeq(), Option.apply((Object)schema), OrcFileFormat.class);
        }
        if (formatTable.format() == FormatTable.Format.PARQUET) {
            return new ParquetTable(ident.name(), SparkSession.active(), dsOptions, JavaConverters.asScalaBuffer(pathList).toSeq(), Option.apply((Object)schema), ParquetFileFormat.class);
        }
        throw new UnsupportedOperationException("Unsupported format table " + ident.name() + " format " + formatTable.format().name());
    }

    protected List<String> convertPartitionTransforms(Transform[] transforms) {
        ArrayList<String> partitionColNames = new ArrayList<String>(transforms.length);
        for (Transform transform : transforms) {
            if (!(transform instanceof IdentityTransform)) {
                throw new UnsupportedOperationException("Unsupported partition transform: " + transform);
            }
            NamedReference ref = ((IdentityTransform)transform).ref();
            if (!(ref instanceof FieldReference) && ref.fieldNames().length == 1) {
                throw new UnsupportedOperationException("Unsupported partition transform: " + transform);
            }
            partitionColNames.add(ref.fieldNames()[0]);
        }
        return partitionColNames;
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            List<PropertyChange> propertyChanges = Arrays.stream(changes).map(this::toPropertyChange).collect(Collectors.toList());
            this.catalog.alterDatabase(databaseName, propertyChanges, false);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    private PropertyChange toPropertyChange(NamespaceChange change) {
        if (change instanceof NamespaceChange.SetProperty) {
            NamespaceChange.SetProperty set = (NamespaceChange.SetProperty)change;
            return PropertyChange.setProperty(set.property(), set.value());
        }
        if (change instanceof NamespaceChange.RemoveProperty) {
            NamespaceChange.RemoveProperty remove = (NamespaceChange.RemoveProperty)change;
            return PropertyChange.removeProperty(remove.property());
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    private String getDatabaseNameFromNamespace(String[] namespace) {
        return namespace[0];
    }
}

