/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.crosspartition;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.paimon.crosspartition.BucketAssigner;
import org.apache.paimon.crosspartition.ExistingProcessor;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.ProjectToRowFunction;
import org.apache.paimon.utils.RowIterator;

public class DeleteExistingProcessor
implements ExistingProcessor {
    private final ProjectToRowFunction setPartition;
    private final BucketAssigner bucketAssigner;
    private final BiConsumer<InternalRow, Integer> collector;

    public DeleteExistingProcessor(ProjectToRowFunction setPartition, BucketAssigner bucketAssigner, BiConsumer<InternalRow, Integer> collector) {
        this.setPartition = setPartition;
        this.bucketAssigner = bucketAssigner;
        this.collector = collector;
    }

    @Override
    public boolean processExists(InternalRow newRow, BinaryRow previousPart, int previousBucket) {
        InternalRow retract = this.setPartition.apply(newRow, previousPart);
        retract.setRowKind(RowKind.DELETE);
        this.collector.accept(retract, previousBucket);
        this.bucketAssigner.decrement(previousPart, previousBucket);
        return true;
    }

    @Override
    public void bulkLoadNewRecords(Function<ExistingProcessor.SortOrder, RowIterator> iteratorFunction, Function<InternalRow, BinaryRow> extractPrimary, Function<InternalRow, BinaryRow> extractPartition, Function<BinaryRow, Integer> assignBucket) {
        ExistingProcessor.bulkLoadCollectFirst(this.collector, iteratorFunction.apply(ExistingProcessor.SortOrder.DESCENDING), extractPrimary, extractPartition, assignBucket);
    }
}

