/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalyst.analysis;

import java.io.Serializable;
import org.apache.paimon.spark.catalyst.Compatibility$;
import org.apache.spark.sql.PaimonUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.PartitionSpec;
import org.apache.spark.sql.catalyst.analysis.ResolvePartitionSpec$;
import org.apache.spark.sql.catalyst.analysis.ResolvedPartitionSpec;
import org.apache.spark.sql.catalyst.analysis.UnresolvedPartitionSpec;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class PaimonResolvePartitionSpec$ {
    public static PaimonResolvePartitionSpec$ MODULE$;

    static {
        new PaimonResolvePartitionSpec$();
    }

    public ResolvedPartitionSpec resolve(TableCatalog catalog, Identifier tableIndent, PartitionSpec partitionSpec) {
        ResolvedPartitionSpec resolvedPartitionSpec;
        SupportsPartitionManagement table = DataSourceV2Implicits$.MODULE$.TableHelper(catalog.loadTable(tableIndent)).asPartitionable();
        PartitionSpec partitionSpec2 = partitionSpec;
        if (partitionSpec2 instanceof UnresolvedPartitionSpec) {
            UnresolvedPartitionSpec unresolvedPartitionSpec = (UnresolvedPartitionSpec)partitionSpec2;
            StructType partitionSchema = table.partitionSchema();
            resolvedPartitionSpec = this.resolvePartitionSpec(table.name(), unresolvedPartitionSpec, partitionSchema, false);
        } else {
            resolvedPartitionSpec = (ResolvedPartitionSpec)partitionSpec2;
        }
        return resolvedPartitionSpec;
    }

    private ResolvedPartitionSpec resolvePartitionSpec(String tableName, UnresolvedPartitionSpec partSpec, StructType partSchema, boolean allowPartitionSpec) {
        Map normalizedSpec = PaimonUtils$.MODULE$.normalizePartitionSpec(partSpec.spec(), partSchema, tableName, (Function2<String, String, Object>)ResolvePartitionSpec$.MODULE$.conf().resolver());
        if (!allowPartitionSpec) {
            PaimonUtils$.MODULE$.requireExactMatchedPartitionSpec(tableName, normalizedSpec, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partSchema.fieldNames()));
        }
        Set partitionNames = normalizedSpec.keySet();
        Seq requestedFields = (Seq)partSchema.filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)partitionNames.contains((Object)field.name())));
        return new ResolvedPartitionSpec((Seq)requestedFields.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom()), this.convertToPartIdent(normalizedSpec, (Seq<StructField>)requestedFields), partSpec.location());
    }

    public InternalRow convertToPartIdent(Map<String, String> partitionSpec, Seq<StructField> schema) {
        Seq partValues = (Seq)schema.map((Function1 & Serializable & scala.Serializable)part -> {
            String raw = (String)partitionSpec.get((Object)part.name()).orNull(Predef$.MODULE$.$conforms());
            DataType dt = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(part.dataType());
            Cast qual$1 = Compatibility$.MODULE$.cast((Expression)Literal$.MODULE$.create((Object)raw, (DataType)StringType$.MODULE$), dt, (Option<String>)new Some((Object)ResolvePartitionSpec$.MODULE$.conf().sessionLocalTimeZone()), Compatibility$.MODULE$.cast$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            return qual$1.eval(x$1);
        }, Seq$.MODULE$.canBuildFrom());
        return InternalRow$.MODULE$.fromSeq(partValues);
    }

    private PaimonResolvePartitionSpec$() {
        MODULE$ = this;
    }
}

