/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.commands;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.crosspartition.IndexBootstrap;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.AppendDeletionFileMaintainer;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.SimpleHashBucketAssigner;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTableWrite;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.commands.BucketExpression$;
import org.apache.paimon.spark.commands.BucketProcessor;
import org.apache.paimon.spark.commands.CommonBucketProcessor;
import org.apache.paimon.spark.commands.DynamicBucketProcessor;
import org.apache.paimon.spark.commands.EncoderSerDeGroup;
import org.apache.paimon.spark.commands.GlobalDynamicBucketProcessor;
import org.apache.paimon.spark.commands.PaimonSparkWriter$;
import org.apache.paimon.spark.commands.PaimonSparkWriter$ModPartitioner$;
import org.apache.paimon.spark.commands.SparkDeletionVectors;
import org.apache.paimon.spark.schema.SparkSystemColumns$;
import org.apache.paimon.spark.util.OptionUtils$;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.PartitionStatisticsReporter;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001\u0002\u001f>\u0001\"C\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t9\u0002\u0011\t\u0012)A\u0005/\")Q\f\u0001C\u0001=\"A!\r\u0001EC\u0002\u0013%1\r\u0003\u0005k\u0001!\u0015\r\u0011\"\u0003l\u0011!\u0011\b\u0001#b\u0001\n\u0013\u0019\b\u0002C<\u0001\u0011\u000b\u0007I\u0011\u0002=\t\u0011q\u0004\u0001R1A\u0005\nuD!\"!\u0003\u0001\u0011\u000b\u0007I\u0011BA\u0006\u0011%\t\t\u0003\u0001b\u0001\n\u0003\t\u0019\u0003\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqAa\u0001\u0001\t\u0013\u0011)A\u0002\u0004\u0003\u000e\u0001!%q\u0002\u0005\u000b\u00053)\"Q3A\u0005\u0002\tm\u0001B\u0003B\u000f+\tE\t\u0015!\u0003\u0002Z\"1Q,\u0006C\u0001\u0005?AqAa\n\u0016\t\u0003\u0012Y\u0002C\u0004\u0003*U!\tEa\u000b\t\u0013\t]R#!A\u0005\u0002\te\u0002\"\u0003B\u001f+E\u0005I\u0011\u0001B \u0011%\u0011)&FA\u0001\n\u0003\u00129\u0006C\u0005\u0003jU\t\t\u0011\"\u0001\u0003\u001c!I!1N\u000b\u0002\u0002\u0013\u0005!Q\u000e\u0005\n\u0005g*\u0012\u0011!C!\u0005kB\u0011Ba!\u0016\u0003\u0003%\tA!\"\t\u0013\t%U#!A\u0005B\t-\u0005\"\u0003BG+\u0005\u0005I\u0011\tBH\u0011%\u0011\t*FA\u0001\n\u0003\u0012\u0019jB\u0005\u0003\u0018\u0002\t\t\u0011#\u0003\u0003\u001a\u001aI!Q\u0002\u0001\u0002\u0002#%!1\u0014\u0005\u0007;\u001a\"\tA!+\t\u0013\t5e%!A\u0005F\t=\u0005\"\u0003BVM\u0005\u0005I\u0011\u0011BW\u0011%\u0011\tLJA\u0001\n\u0003\u0013\u0019\fC\u0005\u00038\u0001\t\t\u0011\"\u0001\u0003@\"I!Q\b\u0001\u0012\u0002\u0013\u0005!1\u0019\u0005\n\u0005+\u0002\u0011\u0011!C!\u0005/B\u0011B!\u001b\u0001\u0003\u0003%\tAa\u0007\t\u0013\t-\u0004!!A\u0005\u0002\t\u001d\u0007\"\u0003B:\u0001\u0005\u0005I\u0011\tB;\u0011%\u0011\u0019\tAA\u0001\n\u0003\u0011Y\rC\u0005\u0003\n\u0002\t\t\u0011\"\u0011\u0003\f\"I!Q\u0012\u0001\u0002\u0002\u0013\u0005#q\u0012\u0005\n\u0005#\u0003\u0011\u0011!C!\u0005\u001f<\u0011Ba5>\u0003\u0003E\tA!6\u0007\u0011qj\u0014\u0011!E\u0001\u0005/Da!\u0018\u001c\u0005\u0002\tm\u0007\"\u0003BGm\u0005\u0005IQ\tBH\u0011%\u0011YKNA\u0001\n\u0003\u0013i\u000eC\u0005\u00032Z\n\t\u0011\"!\u0003b\"I!q\u001d\u001c\u0002\u0002\u0013%!\u0011\u001e\u0002\u0012!\u0006LWn\u001c8Ta\u0006\u00148n\u0016:ji\u0016\u0014(B\u0001 @\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001!B\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00115)\u0001\u0004qC&lwN\u001c\u0006\u0003\t\u0016\u000ba!\u00199bG\",'\"\u0001$\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001IuJ\u0015\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)\u0003\u0016BA)L\u0005\u001d\u0001&o\u001c3vGR\u0004\"AS*\n\u0005Q[%\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0002;bE2,W#A,\u0011\u0005aSV\"A-\u000b\u0005U\u000b\u0015BA.Z\u000591\u0015\u000e\\3Ti>\u0014X\rV1cY\u0016\fa\u0001^1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002`CB\u0011\u0001\rA\u0007\u0002{!)Qk\u0001a\u0001/\u0006YA/\u00192mKN\u001b\u0007.Z7b+\u0005!\u0007CA3i\u001b\u00051'BA4B\u0003\u0019\u00198\r[3nC&\u0011\u0011N\u001a\u0002\f)\u0006\u0014G.Z*dQ\u0016l\u0017-A\u0004s_^$\u0016\u0010]3\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\!\u0002\u000bQL\b/Z:\n\u0005Et'a\u0002*poRK\b/Z\u0001\u000bEV\u001c7.\u001a;N_\u0012,W#\u0001;\u0011\u0005a+\u0018B\u0001<Z\u0005)\u0011UoY6fi6{G-Z\u0001\u0013I&\u001c\u0018M\u00197f%\u0016\u0004xN\u001d;Ti\u0006$8/F\u0001z!\tQ%0\u0003\u0002|\u0017\n9!i\\8mK\u0006t\u0017a\u00017pOV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rQ)A\u0003tY\u001a$$.\u0003\u0003\u0002\b\u0005\u0005!A\u0002'pO\u001e,'/\u0001\u0006tKJL\u0017\r\\5{KJ,\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005Z\u0003\u0011\u0019\u0018N\\6\n\t\u0005]\u0011\u0011\u0003\u0002\u0018\u0007>lW.\u001b;NKN\u001c\u0018mZ3TKJL\u0017\r\\5{KJD3!CA\u000e!\rQ\u0015QD\u0005\u0004\u0003?Y%!\u0003;sC:\u001c\u0018.\u001a8u\u000319(/\u001b;f\u0005VLG\u000eZ3s+\t\t)\u0003\u0005\u0003\u0002\u0010\u0005\u001d\u0012\u0002BA\u0015\u0003#\u0011\u0011CQ1uG\"<&/\u001b;f\u0005VLG\u000eZ3s\u000359(/\u001b;f\u0005VLG\u000eZ3sA\u0005IqO]5uK>sG.\u001f\u000b\u0002?\u0006)qO]5uKR!\u0011QGA*!\u0019\t9$a\u0012\u0002N9!\u0011\u0011HA\"\u001d\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \u000f\u00061AH]8pizJ\u0011\u0001T\u0005\u0004\u0003\u000bZ\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\nYEA\u0002TKFT1!!\u0012L!\u0011\ty!a\u0014\n\t\u0005E\u0013\u0011\u0003\u0002\u000e\u0007>lW.\u001b;NKN\u001c\u0018mZ3\t\u000f\u0005US\u00021\u0001\u0002X\u0005!A-\u0019;b!\u0011\tI&a\u001d\u000f\t\u0005m\u0013q\u000e\b\u0005\u0003;\nIG\u0004\u0003\u0002`\u0005\u001dd\u0002BA1\u0003KrA!a\u000f\u0002d%\ta)\u0003\u0002E\u000b&\u0011\u0001iQ\u0005\u0005\u0003W\ni'A\u0002tc2T!\u0001Q\"\n\t\u0005\u0015\u0013\u0011\u000f\u0006\u0005\u0003W\ni'\u0003\u0003\u0002v\u0005]$!\u0003#bi\u00064%/Y7f\u0015\u0011\t)%!\u001d\u0002-A,'o]5ti\u0012+G.\u001a;j_:4Vm\u0019;peN$B!!\u000e\u0002~!9\u0011q\u0010\bA\u0002\u0005\u0005\u0015a\u00043fY\u0016$\u0018n\u001c8WK\u000e$xN]:\u0011\r\u0005\r\u0015QQAE\u001b\t\t\t(\u0003\u0003\u0002\b\u0006E$a\u0002#bi\u0006\u001cX\r\u001e\t\u0004A\u0006-\u0015bAAG{\t!2\u000b]1sW\u0012+G.\u001a;j_:4Vm\u0019;peN\f1B]3q_J$Hk\u001c%ngR!\u00111SAM!\rQ\u0015QS\u0005\u0004\u0003/[%\u0001B+oSRDq!a'\u0010\u0001\u0004\t)$\u0001\u0005nKN\u001c\u0018mZ3t\u0003\u0019\u0019w.\\7jiR!\u00111SAQ\u0011\u001d\t\u0019\u000b\u0005a\u0001\u0003k\tabY8n[&$X*Z:tC\u001e,7/\u0001\u0011c_>$8\u000f\u001e:ba\u0006sGMU3qCJ$\u0018\u000e^5p]\nK8*Z=ICNDGCCAU\u0003'\f).a8\u0002dB1\u00111VAY\u0003kk!!!,\u000b\t\u0005=\u0016QN\u0001\u0004e\u0012$\u0017\u0002BAZ\u0003[\u00131A\u0015#E!\u001dQ\u0015qWA^\u0003\u000fL1!!/L\u0005\u0019!V\u000f\u001d7feA!\u0011QXAb\u001b\t\tyLC\u0002\u0002B\u0006\u000bab\u0019:pgN\u0004\u0018M\u001d;ji&|g.\u0003\u0003\u0002F\u0006}&\u0001D&fsB\u000b'\u000f^(s%><\b#\u0002&\u0002J\u00065\u0017bAAf\u0017\n)\u0011I\u001d:bsB\u0019!*a4\n\u0007\u0005E7J\u0001\u0003CsR,\u0007bBA+#\u0001\u0007\u0011q\u000b\u0005\b\u0003/\f\u0002\u0019AAm\u0003-\u0001\u0018M]1mY\u0016d\u0017n]7\u0011\u0007)\u000bY.C\u0002\u0002^.\u00131!\u00138u\u0011\u001d\t\t/\u0005a\u0001\u00033\fQB]8x\u0017&tGmQ8m\u0013\u0012D\b\"\u00026\u0012\u0001\u0004a\u0017!\b:fa\u0006\u0014H/\u001b;j_:\u0014\u0015pS3z!\u0006\u0014H/\u001b;j_:D\u0015m\u001d5\u0015\u0015\u0005]\u0013\u0011^Az\u0003k\f9\u0010C\u0004\u0002lJ\u0001\r!!<\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005\r\u0015q^\u0005\u0005\u0003c\f\tH\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0002VI\u0001\r!a\u0016\t\u000f\u0005]'\u00031\u0001\u0002Z\"9\u0011\u0011 \nA\u0002\u0005e\u0017\u0001\u00048v[\u0006\u001b8/[4oKJ\u001c\u0018\u0001\t:fa\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010U1si&$\u0018n\u001c8t\u0003:$')^2lKR$B!a\u0016\u0002\u0000\"9!\u0011A\nA\u0002\u0005]\u0013A\u00013g\u0003a!Wm]3sS\u0006d\u0017N_3D_6l\u0017\u000e^'fgN\fw-\u001a\u000b\u0007\u0003\u001b\u00129A!\u0003\t\u000f\u0005%A\u00031\u0001\u0002\u000e!9!1\u0002\u000bA\u0002\u0005\u001d\u0017!\u00022zi\u0016\u001c(AD'pIB\u000b'\u000f^5uS>tWM]\n\u0006+\tEqJ\u0015\t\u0005\u0005'\u0011)\"\u0004\u0002\u0002n%!!qCA7\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002Z\u0006Y\u0001/\u0019:uSRLwN\\:!)\u0011\u0011\tC!\n\u0011\u0007\t\rR#D\u0001\u0001\u0011\u001d\u0011I\u0002\u0007a\u0001\u00033\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018\u0001D4fiB\u000b'\u000f^5uS>tG\u0003BAm\u0005[AqAa\f\u001b\u0001\u0004\u0011\t$A\u0002lKf\u00042A\u0013B\u001a\u0013\r\u0011)d\u0013\u0002\u0004\u0003:L\u0018\u0001B2paf$BA!\t\u0003<!I!\u0011D\u000e\u0011\u0002\u0003\u0007\u0011\u0011\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tE\u000b\u0003\u0002Z\n\r3F\u0001B#!\u0011\u00119E!\u0015\u000e\u0005\t%#\u0002\u0002B&\u0005\u001b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=3*\u0001\u0006b]:|G/\u0019;j_:LAAa\u0015\u0003J\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0006\u0005\u0003\u0003\\\t\u0015TB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0005G\nAA[1wC&!!q\rB/\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0019\u0005_B\u0011B!\u001d \u0003\u0003\u0005\r!!7\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\b\u0005\u0004\u0003z\t}$\u0011G\u0007\u0003\u0005wR1A! L\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0003\u0013YH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA=\u0003\b\"I!\u0011O\u0011\u0002\u0002\u0003\u0007!\u0011G\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\\\u0001\ti>\u001cFO]5oOR\u0011!\u0011L\u0001\u0007KF,\u0018\r\\:\u0015\u0007e\u0014)\nC\u0005\u0003r\u0011\n\t\u00111\u0001\u00032\u0005qQj\u001c3QCJ$\u0018\u000e^5p]\u0016\u0014\bc\u0001B\u0012MM!aE!(S!!\u0011yJ!*\u0002Z\n\u0005RB\u0001BQ\u0015\r\u0011\u0019kS\u0001\beVtG/[7f\u0013\u0011\u00119K!)\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0003\u001a\u0006)\u0011\r\u001d9msR!!\u0011\u0005BX\u0011\u001d\u0011I\"\u000ba\u0001\u00033\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u00036\nm\u0006#\u0002&\u00038\u0006e\u0017b\u0001B]\u0017\n1q\n\u001d;j_:D\u0011B!0+\u0003\u0003\u0005\rA!\t\u0002\u0007a$\u0003\u0007F\u0002`\u0005\u0003Dq!V\u0016\u0011\u0002\u0003\u0007q+\u0006\u0002\u0003F*\u001aqKa\u0011\u0015\t\tE\"\u0011\u001a\u0005\n\u0005cz\u0013\u0011!a\u0001\u00033$2!\u001fBg\u0011%\u0011\t(MA\u0001\u0002\u0004\u0011\t\u0004F\u0002z\u0005#D\u0011B!\u001d5\u0003\u0003\u0005\rA!\r\u0002#A\u000b\u0017.\\8o'B\f'o[,sSR,'\u000f\u0005\u0002amM!aG!7S!\u0019\u0011yJ!*X?R\u0011!Q\u001b\u000b\u0004?\n}\u0007\"B+:\u0001\u00049F\u0003\u0002Br\u0005K\u0004BA\u0013B\\/\"A!Q\u0018\u001e\u0002\u0002\u0003\u0007q,A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bv!\u0011\u0011YF!<\n\t\t=(Q\f\u0002\u0007\u001f\nTWm\u0019;")
public class PaimonSparkWriter
implements Product,
scala.Serializable {
    private TableSchema tableSchema;
    private RowType rowType;
    private BucketMode bucketMode;
    private boolean disableReportStats;
    private Logger log;
    private transient CommitMessageSerializer serializer;
    private volatile PaimonSparkWriter$ModPartitioner$ ModPartitioner$module;
    private final FileStoreTable table;
    private final BatchWriteBuilder writeBuilder;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<FileStoreTable> unapply(PaimonSparkWriter paimonSparkWriter) {
        return PaimonSparkWriter$.MODULE$.unapply(paimonSparkWriter);
    }

    public static PaimonSparkWriter apply(FileStoreTable fileStoreTable) {
        return PaimonSparkWriter$.MODULE$.apply(fileStoreTable);
    }

    public static <A> Function1<FileStoreTable, A> andThen(Function1<PaimonSparkWriter, A> function1) {
        return PaimonSparkWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PaimonSparkWriter> compose(Function1<A, FileStoreTable> function1) {
        return PaimonSparkWriter$.MODULE$.compose(function1);
    }

    private PaimonSparkWriter$ModPartitioner$ ModPartitioner() {
        if (this.ModPartitioner$module == null) {
            this.ModPartitioner$lzycompute$1();
        }
        return this.ModPartitioner$module;
    }

    public FileStoreTable table() {
        return this.table;
    }

    private TableSchema tableSchema$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableSchema;
    }

    private TableSchema tableSchema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private RowType rowType$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.rowType = this.table().rowType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rowType;
    }

    private RowType rowType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rowType$lzycompute() : this.rowType;
    }

    private BucketMode bucketMode$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bucketMode = this.table().bucketMode();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bucketMode;
    }

    private BucketMode bucketMode() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.bucketMode$lzycompute() : this.bucketMode;
    }

    private boolean disableReportStats$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                CoreOptions options = this.table().coreOptions();
                Options config = options.toConfiguration();
                this.disableReportStats = config.get(CoreOptions.PARTITION_IDLE_TIME_TO_REPORT_STATISTIC).toMillis() <= 0L || this.table().partitionKeys().isEmpty() || !options.partitionedTableInMetastore() || this.table().catalogEnvironment().partitionHandler() == null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.disableReportStats;
    }

    private boolean disableReportStats() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.disableReportStats$lzycompute() : this.disableReportStats;
    }

    private Logger log$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.log = LoggerFactory.getLogger(PaimonSparkWriter.class);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.log;
    }

    private Logger log() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.log$lzycompute() : this.log;
    }

    private CommitMessageSerializer serializer$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (!this.bitmap$trans$0) {
                this.serializer = new CommitMessageSerializer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.serializer;
    }

    private CommitMessageSerializer serializer() {
        return !this.bitmap$trans$0 ? this.serializer$lzycompute() : this.serializer;
    }

    public BatchWriteBuilder writeBuilder() {
        return this.writeBuilder;
    }

    public PaimonSparkWriter writeOnly() {
        return new PaimonSparkWriter((FileStoreTable)this.table().copy((Map)Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true")));
    }

    public Seq<CommitMessage> write(Dataset<Row> data) {
        Dataset dataset;
        SparkSession sparkSession = data.sparkSession();
        BucketMode bucketMode = this.bucketMode();
        Dataset dataset2 = ((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode) ? data : (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode) && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).contains((Object)SparkSystemColumns$.MODULE$.ROW_KIND_COL()) ? data.withColumn(SparkSystemColumns$.MODULE$.ROW_KIND_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)RowKind.INSERT.toByteValue()))).withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))) : data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))));
        Dataset withInitBucketCol = dataset2;
        int rowKindColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.ROW_KIND_COL());
        int bucketColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.BUCKET_COL());
        EncoderSerDeGroup encoderGroupWithBucketCol = new EncoderSerDeGroup(withInitBucketCol.schema());
        BucketMode bucketMode2 = this.bucketMode();
        if (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode2)) {
            RowType rowType = (RowType)SparkTypeUtils.toPaimonType((DataType)withInitBucketCol.schema());
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapped = this.bootstrapAndRepartitionByKeyHash((Dataset<Row>)withInitBucketCol, assignerParallelism, rowKindColIdx, rowType);
            GlobalDynamicBucketProcessor globalDynamicBucketProcessor = new GlobalDynamicBucketProcessor(this.table(), rowType, Predef$.MODULE$.int2Integer(assignerParallelism), encoderGroupWithBucketCol);
            Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)sparkSession.createDataFrame(bootstrapped.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> globalDynamicBucketProcessor.processPartition((Iterator<Tuple2<KeyPartOrRow, byte[]>>)rowIterator), bootstrapped.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), withInitBucketCol.schema()));
            dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_DYNAMIC)).equals((Object)bucketMode2)) {
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            int numAssigners = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketInitialBuckets()).map((Function1 & Serializable & scala.Serializable)initialBuckets -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$13(assignerParallelism, initialBuckets))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> assignerParallelism));
            dataset = this.table().snapshotManager().latestSnapshot() == null ? this.writeWithBucketAssigner$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), (Function0 & Serializable & scala.Serializable)() -> {
                RowPartitionKeyExtractor extractor = new RowPartitionKeyExtractor(this.table().schema());
                SimpleHashBucketAssigner assigner = new SimpleHashBucketAssigner(numAssigners, TaskContext$.MODULE$.getPartitionId(), this.table().coreOptions().dynamicBucketTargetRowNum(), Predef$.MODULE$.Integer2int(this.table().coreOptions().dynamicBucketMaxBuckets()));
                return (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$16(this, assigner, extractor, row));
            }, sparkSession, rowKindColIdx) : this.writeWithBucketProcessor$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), new DynamicBucketProcessor(this.table(), bucketColIdx, assignerParallelism, numAssigners, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode2)) {
            dataset = this.writeWithoutBucket$1(data, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_FIXED)).equals((Object)bucketMode2)) {
            Dataset dataset3;
            if (this.table().bucketSpec().getNumBuckets() == -2) {
                dataset3 = this.writeWithoutBucket$1(data, sparkSession, rowKindColIdx);
            } else if (!OptionUtils$.MODULE$.paimonExtensionEnabled()) {
                dataset3 = this.writeWithBucketProcessor$1(withInitBucketCol, new CommonBucketProcessor(this.table(), bucketColIdx, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
            } else {
                int bucketNumber = this.table().coreOptions().bucket();
                Seq bucketKeyCol = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().bucketKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$17(this, x$3)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(data.schema().fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Seq args2 = (Seq)((TraversableLike)new .colon.colon((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)bucketNumber)), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)bucketKeyCol, Seq$.MODULE$.canBuildFrom());
                Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.call_udf(BucketExpression$.MODULE$.FIXED_BUCKET(), args2)));
                dataset3 = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
            }
            dataset = dataset3;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Spark doesn't support ").append((Object)this.bucketMode()).append(" mode.").toString());
        }
        Dataset written = dataset;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])written.collect())).map((Function1 & Serializable & scala.Serializable)x$4 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CommitMessage.class))))).toSeq();
    }

    public Seq<CommitMessage> persistDeletionVectors(Dataset<SparkDeletionVectors> deletionVectors) {
        SparkSession sparkSession = deletionVectors.sparkSession();
        Snapshot snapshot = this.table().snapshotManager().latestSnapshot();
        Dataset serializedCommits = deletionVectors.groupByKey((Function1 & Serializable & scala.Serializable)x$5 -> x$5.partitionAndBucket(), sparkSession.implicits().newStringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(x$6, iter) -> {
            IndexFileHandler indexHandler = this.table().store().newIndexFileHandler();
            ObjectRef dvIndexFileMaintainer = ObjectRef.create(null);
            while (iter.hasNext()) {
                SparkDeletionVectors sdv = (SparkDeletionVectors)iter.next();
                if ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem == null) {
                    BinaryRow partition = SerializationUtils.deserializeBinaryRow(sdv.partition());
                    BucketMode bucketMode = this.bucketMode();
                    BucketMode bucketMode2 = BucketMode.BUCKET_UNAWARE;
                    Object object = !(bucketMode != null ? !((Object)((Object)bucketMode)).equals((Object)bucketMode2) : bucketMode2 != null) ? AppendDeletionFileMaintainer.forUnawareAppend(indexHandler, snapshot, partition) : (dvIndexFileMaintainer.elem = AppendDeletionFileMaintainer.forBucketedAppend(indexHandler, snapshot, partition, sdv.bucket()));
                }
                if ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem == null) {
                    throw new RuntimeException("can't create the dv maintainer.");
                }
                sdv.dataFileAndDeletionVector().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    PaimonSparkWriter.$anonfun$persistDeletionVectors$3(dvIndexFileMaintainer, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            java.util.List<IndexManifestEntry> indexEntries = ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).persist();
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexEntries).asScala()).partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$persistDeletionVectors$4(x$7)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer added = (Buffer)tuple2._1();
            Buffer deleted = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)added, (Object)deleted);
            Tuple2 tuple23 = tuple22;
            Buffer added2 = (Buffer)tuple23._1();
            Buffer deleted2 = (Buffer)tuple23._2();
            CommitMessageImpl commitMessage = new CommitMessageImpl(((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).getPartition(), ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).getBucket(), null, DataIncrement.emptyIncrement(), CompactIncrement.emptyIncrement(), new IndexIncrement((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)added2.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deleted2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava()));
            CommitMessageSerializer serializer = new CommitMessageSerializer();
            return serializer.serialize(commitMessage);
        }, sparkSession.implicits().newByteArrayEncoder());
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedCommits.collect())).map((Function1 & Serializable & scala.Serializable)x$11 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$11), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private void reportToHms(Seq<CommitMessage> messages) {
        if (this.disableReportStats()) {
            return;
        }
        CoreOptions options = this.table().coreOptions();
        InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(options.partitionDefaultName(), this.table().schema().logicalPartitionType(), (String[])this.table().partitionKeys().toArray((Object[])new String[0]), options.legacyPartitionName());
        PartitionStatisticsReporter hmsReporter = new PartitionStatisticsReporter(this.table(), this.table().catalogEnvironment().partitionHandler());
        Seq partitions = (Seq)((SeqLike)messages.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.partition(), Seq$.MODULE$.canBuildFrom())).distinct();
        long currentTime = System.currentTimeMillis();
        try {
            try {
                partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    PaimonSparkWriter.$anonfun$reportToHms$2(partitionComputer, hmsReporter, currentTime, partition);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable e) {
                this.log().warn("Failed to report to hms", e);
            }
        }
        finally {
            hmsReporter.close();
        }
    }

    public void commit(Seq<CommitMessage> commitMessages) {
        try (BatchTableCommit tableCommit = this.writeBuilder().newCommit();){
            try {
                tableCommit.commit((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)commitMessages.toList()).asJava());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        this.reportToHms(commitMessages);
    }

    private RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapAndRepartitionByKeyHash(Dataset<Row> data, int parallelism, int rowKindColIdx, RowType rowType) {
        int numSparkPartitions = data.rdd().getNumPartitions();
        java.util.List<String> primaryKeys = this.table().schema().primaryKeys();
        RowType bootstrapType = IndexBootstrap.bootstrapType(this.table().schema());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
            Projection keyPartProject = CodeGenUtils.newProjection(bootstrapType, primaryKeys);
            Projection rowProject = CodeGenUtils.newProjection(rowType, primaryKeys);
            InternalRowSerializer bootstrapSer = InternalSerializers.create(bootstrapType);
            InternalRowSerializer rowSer = InternalSerializers.create(rowType);
            CloseableIterator<InternalRow> bootstrapIterator = new IndexBootstrap(this.table()).bootstrap(numSparkPartitions, sparkPartitionId).toCloseableIterator();
            TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$13 -> {
                bootstrapIterator.close();
                return BoxedUnit.UNIT;
            });
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(bootstrapIterator).asScala()).map((Function1 & Serializable & scala.Serializable)row -> {
                byte[] bytes = SerializationUtils.serializeBinaryRow(bootstrapSer.toBinaryRow((InternalRow)row));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Math.abs(keyPartProject.apply((InternalRow)row).hashCode())), (Object)new Tuple2((Object)KeyPartOrRow.KEY_PART, (Object)bytes));
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter.map((Function1 & Serializable & scala.Serializable)r -> {
                SparkRow sparkRow = new SparkRow(rowType, (Row)r, SparkRowUtils$.MODULE$.getRowKind((Row)r, rowKindColIdx));
                byte[] bytes = SerializationUtils.serializeBinaryRow(rowSer.toBinaryRow(sparkRow));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Math.abs(rowProject.apply(sparkRow).hashCode())), (Object)new Tuple2((Object)KeyPartOrRow.ROW, (Object)bytes));
            }));
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$14 -> (Tuple2)x$14._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Dataset<Row> repartitionByKeyPartitionHash(SparkSession sparkSession, Dataset<Row> data, int parallelism, int numAssigners) {
        return sparkSession.createDataFrame(RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iterator2 -> {
            RowPartitionKeyExtractor rowPartitionKeyExtractor = new RowPartitionKeyExtractor(this.tableSchema());
            return iterator2.map((Function1 & Serializable & scala.Serializable)row -> {
                SparkRow sparkRow = new SparkRow(this.rowType(), (Row)row);
                int partitionHash = rowPartitionKeyExtractor.partition(sparkRow).hashCode();
                int keyHash = rowPartitionKeyExtractor.trimmedPrimaryKey(sparkRow).hashCode();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BucketAssigner.computeHashKey(partitionHash, keyHash, parallelism, numAssigners)), row);
            });
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$15 -> (Row)x$15._2(), ClassTag$.MODULE$.apply(Row.class)), data.schema());
    }

    private Dataset<Row> repartitionByPartitionsAndBucket(Dataset<Row> df) {
        StructType inputSchema = df.schema();
        Seq partitionCols = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().partitionKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$repartitionByPartitionsAndBucket$1(this, x$16)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(inputSchema.fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
        return df.repartition((Seq)partitionCols.$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.col(SparkSystemColumns$.MODULE$.BUCKET_COL()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
    }

    private CommitMessage deserializeCommitMessage(CommitMessageSerializer serializer, byte[] bytes) {
        CommitMessage commitMessage;
        try {
            commitMessage = serializer.deserialize(serializer.getVersion(), bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize CommitMessage's object", e);
        }
        return commitMessage;
    }

    public PaimonSparkWriter copy(FileStoreTable table) {
        return new PaimonSparkWriter(table);
    }

    public FileStoreTable copy$default$1() {
        return this.table();
    }

    public String productPrefix() {
        return "PaimonSparkWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.table();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PaimonSparkWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PaimonSparkWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        PaimonSparkWriter paimonSparkWriter = (PaimonSparkWriter)x$1;
        FileStoreTable fileStoreTable = this.table();
        FileStoreTable fileStoreTable2 = paimonSparkWriter.table();
        if (fileStoreTable == null) {
            if (fileStoreTable2 != null) {
                return false;
            }
        } else if (!fileStoreTable.equals(fileStoreTable2)) return false;
        if (!paimonSparkWriter.canEqual(this)) return false;
        return true;
    }

    private final void ModPartitioner$lzycompute$1() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (this.ModPartitioner$module == null) {
                this.ModPartitioner$module = new PaimonSparkWriter$ModPartitioner$(this);
            }
        }
    }

    private final SparkTableWrite newWrite$1(int rowKindColIdx$1) {
        return new SparkTableWrite(this.writeBuilder(), this.rowType(), rowKindColIdx$1);
    }

    private static final int sparkParallelism$1(SparkSession sparkSession$1) {
        int defaultParallelism = sparkSession$1.sparkContext().defaultParallelism();
        int numShufflePartitions = sparkSession$1.sessionState().conf().numShufflePartitions();
        return Math.max(defaultParallelism, numShufflePartitions);
    }

    private final Dataset writeWithoutBucket$1(Dataset dataFrame, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row);
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucket$1(Dataset dataFrame, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, row.getInt(bucketColIdx$1));
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucketProcessor$1(Dataset dataFrame, BucketProcessor processor, EncoderSerDeGroup encoderGroupWithBucketCol$1, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> processor.processPartition(rowIterator), encoderGroupWithBucketCol$1.encoder()).toDF());
        return this.writeWithBucket$1(repartitioned, bucketColIdx$1, sparkSession$1, rowKindColIdx$1);
    }

    private final Dataset writeWithBucketAssigner$1(Dataset dataFrame, Function0 funcFactory, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            Function1 assigner = (Function1)funcFactory.apply();
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, BoxesRunTime.unboxToInt((Object)assigner.apply((Object)row)));
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    public static final /* synthetic */ int $anonfun$write$13(int assignerParallelism$1, Integer initialBuckets) {
        return Math.min(Predef$.MODULE$.Integer2int(initialBuckets), assignerParallelism$1);
    }

    private final Dataset partitionByKey$1(SparkSession sparkSession$1, Dataset withInitBucketCol$1, int assignerParallelism$1, int numAssigners$1) {
        return this.repartitionByKeyPartitionHash(sparkSession$1, (Dataset<Row>)withInitBucketCol$1, assignerParallelism$1, numAssigners$1);
    }

    public static final /* synthetic */ int $anonfun$write$16(PaimonSparkWriter $this, SimpleHashBucketAssigner assigner$2, RowPartitionKeyExtractor extractor$1, Row row) {
        SparkRow sparkRow = new SparkRow($this.rowType(), row);
        return assigner$2.assign(extractor$1.partition(sparkRow), extractor$1.trimmedPrimaryKey(sparkRow).hashCode());
    }

    public static final /* synthetic */ int $anonfun$write$17(PaimonSparkWriter $this, String x$3) {
        return $this.tableSchema().fieldNames().indexOf(x$3);
    }

    public static final /* synthetic */ void $anonfun$persistDeletionVectors$3(ObjectRef dvIndexFileMaintainer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dataFileName = (String)tuple2._1();
        byte[] dv = (byte[])tuple2._2();
        ((AppendDeletionFileMaintainer)dvIndexFileMaintainer$1.elem).notifyNewDeletionVector(dataFileName, DeletionVector.deserializeFromBytes(dv));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$persistDeletionVectors$4(IndexManifestEntry x$7) {
        FileKind fileKind = x$7.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public static final /* synthetic */ void $anonfun$reportToHms$2(InternalRowPartitionComputer partitionComputer$1, PartitionStatisticsReporter hmsReporter$1, long currentTime$1, BinaryRow partition) {
        String partitionPath = PartitionPathUtils.generatePartitionPath(partitionComputer$1.generatePartValues(partition));
        hmsReporter$1.report(partitionPath, currentTime$1);
    }

    public static final /* synthetic */ int $anonfun$repartitionByPartitionsAndBucket$1(PaimonSparkWriter $this, String x$16) {
        return $this.tableSchema().fieldNames().indexOf(x$16);
    }

    public PaimonSparkWriter(FileStoreTable table) {
        this.table = table;
        Product.$init$((Product)this);
        this.writeBuilder = table.newBatchWriteBuilder();
    }

    private class ModPartitioner
    extends Partitioner
    implements Product {
        private final int partitions;
        public final /* synthetic */ PaimonSparkWriter $outer;

        public int partitions() {
            return this.partitions;
        }

        public int numPartitions() {
            return this.partitions();
        }

        public int getPartition(Object key) {
            return BoxesRunTime.unboxToInt((Object)key) % this.numPartitions();
        }

        public ModPartitioner copy(int partitions) {
            return new ModPartitioner(this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer(), partitions);
        }

        public int copy$default$1() {
            return this.partitions();
        }

        public String productPrefix() {
            return "ModPartitioner";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return BoxesRunTime.boxToInteger((int)this.partitions());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ModPartitioner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partitions());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ModPartitioner)) return false;
            if (((ModPartitioner)((Object)object)).org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() != this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ModPartitioner modPartitioner = (ModPartitioner)((Object)x$1);
            if (this.partitions() != modPartitioner.partitions()) return false;
            if (!modPartitioner.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ PaimonSparkWriter org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() {
            return this.$outer;
        }

        public ModPartitioner(PaimonSparkWriter $outer, int partitions) {
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

