/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.spark.DataConverter;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.TypeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.SupportsAtomicPartitionManagement;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4\u0001BC\u0006\u0011\u0002\u0007\u0005A#\u001f\u0005\u0006Q\u0001!\t!\u000b\u0005\ta\u0001A)\u0019!C\u0001c!A\u0001\b\u0001EC\u0002\u0013\u0005\u0013\bC\u0003@\u0001\u0011%\u0001\tC\u0003_\u0001\u0011\u0005s\fC\u0003e\u0001\u0011\u0005S\rC\u0003k\u0001\u0011\u00053\u000eC\u0003n\u0001\u0011\u0005c\u000eC\u0003u\u0001\u0011\u0005SOA\rQC&lwN\u001c)beRLG/[8o\u001b\u0006t\u0017mZ3nK:$(B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004qC&lwN\u001c\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)R\u0004\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005!A.\u00198h\u0015\u0005Q\u0012\u0001\u00026bm\u0006L!\u0001H\f\u0003\r=\u0013'.Z2u!\tqb%D\u0001 \u0015\t\u0001\u0013%A\u0004dCR\fGn\\4\u000b\u0005\t\u001a\u0013!C2p]:,7\r^8s\u0015\t!S%A\u0002tc2T!\u0001D\b\n\u0005\u001dz\"!I*vaB|'\u000f^:Bi>l\u0017n\u0019)beRLG/[8o\u001b\u0006t\u0017mZ3nK:$\u0018A\u0002\u0013j]&$H\u0005F\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;\u0002!A\f'\u000f^5uS>t'k\\<UsB,W#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Uj\u0011!\u0002;za\u0016\u001c\u0018BA\u001c5\u0005\u001d\u0011vn\u001e+za\u0016\fq\u0002]1si&$\u0018n\u001c8TG\",W.Y\u000b\u0002uA\u00111(P\u0007\u0002y)\u0011QgI\u0005\u0003}q\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003I!x\u000eU1j[>t\u0007+\u0019:uSRLwN\\:\u0015\u0005\u0005+\u0006cA\u0016C\t&\u00111\t\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u000b\"S%*D\u0001G\u0015\t9\u0015$\u0001\u0003vi&d\u0017BA%G\u0005\ri\u0015\r\u001d\t\u0003\u0017Js!\u0001\u0014)\u0011\u00055cS\"\u0001(\u000b\u0005=\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002RY\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\tF\u0006C\u0003W\t\u0001\u0007q+\u0001\u0003s_^\u001c\bcA\u0016C1B\u0011\u0011\fX\u0007\u00025*\u00111lI\u0001\tG\u0006$\u0018\r\\=ti&\u0011QL\u0017\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\bee>\u0004\b+\u0019:uSRLwN\\:\u0015\u0005\u0001\u001c\u0007CA\u0016b\u0013\t\u0011GFA\u0004C_>dW-\u00198\t\u000bY+\u0001\u0019A,\u00021I,\u0007\u000f\\1dKB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rF\u0002+M\"DQa\u001a\u0004A\u0002a\u000bQ!\u001b3f]RDQ!\u001b\u0004A\u0002\u0011\u000b!\u0002\u001d:pa\u0016\u0014H/[3t\u0003Uaw.\u00193QCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006$\"\u0001\u00127\t\u000b\u001d<\u0001\u0019\u0001-\u000211L7\u000f\u001e)beRLG/[8o\u0013\u0012,g\u000e^5gS\u0016\u00148\u000fF\u0002X_JDQ\u0001\u001d\u0005A\u0002E\fQ\u0002]1si&$\u0018n\u001c8D_2\u001c\bcA\u0016C\u0015\")1\u000f\u0003a\u00011\u0006Y\u0011N\u001c;fe:\fGNU8x\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000fF\u0002+m^DQAV\u0005A\u0002]CQ\u0001_\u0005A\u0002\u0005\u000bA!\\1qgB\u0011!p_\u0007\u0002\u0017%\u0011Ap\u0003\u0002\u000b'B\f'o\u001b+bE2,\u0007")
public interface PaimonPartitionManagement
extends SupportsAtomicPartitionManagement {
    public static /* synthetic */ RowType partitionRowType$(PaimonPartitionManagement $this) {
        return $this.partitionRowType();
    }

    default public RowType partitionRowType() {
        return TypeUtils.project(((SparkTable)this).table().rowType(), ((SparkTable)this).table().partitionKeys());
    }

    public static /* synthetic */ StructType partitionSchema$(PaimonPartitionManagement $this) {
        return $this.partitionSchema();
    }

    default public StructType partitionSchema() {
        return SparkTypeUtils.fromPaimonRowType(this.partitionRowType());
    }

    private java.util.Map<String, String>[] toPaimonPartitions(InternalRow[] rows) {
        Table table = ((SparkTable)this).table();
        if (table instanceof FileStoreTable) {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            Function1 rowConverter = CatalystTypeConverters$.MODULE$.createToScalaConverter(CharVarcharUtils$.MODULE$.replaceCharVarcharWithString((DataType)this.partitionSchema()));
            InternalRowPartitionComputer rowDataPartitionComputer = new InternalRowPartitionComputer(fileStoreTable.coreOptions().partitionDefaultName(), this.partitionRowType(), (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SparkTable)this).table().partitionKeys()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), CoreOptions.fromMap(((SparkTable)this).table().options()).legacyPartitionName());
            return (java.util.Map[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).map((Function1 & Serializable & scala.Serializable)r -> rowDataPartitionComputer.generatePartValues(new SparkRow(this.partitionRowType(), (Row)rowConverter.apply(r))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.util.Map.class)));
        }
        throw new UnsupportedOperationException("Only FileStoreTable supports partitions.");
    }

    public static /* synthetic */ boolean dropPartitions$(PaimonPartitionManagement $this, InternalRow[] rows) {
        return $this.dropPartitions(rows);
    }

    default public boolean dropPartitions(InternalRow[] rows) {
        Table table = ((SparkTable)this).table();
        if (table instanceof FileStoreTable) {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            List partitions = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.toPaimonPartitions(rows))).toSeq()).asJava();
            PartitionHandler partitionHandler = fileStoreTable.catalogEnvironment().partitionHandler();
            if (partitionHandler != null) {
                try {
                    partitionHandler.dropPartitions(partitions);
                }
                finally {
                    partitionHandler.close();
                }
            }
            try (BatchTableCommit commit = fileStoreTable.newBatchWriteBuilder().newCommit();){
                commit.truncatePartitions(partitions);
            }
            return true;
        }
        throw new UnsupportedOperationException("Only FileStoreTable supports drop partitions.");
    }

    public static /* synthetic */ void replacePartitionMetadata$(PaimonPartitionManagement $this, InternalRow ident, java.util.Map properties) {
        $this.replacePartitionMetadata(ident, properties);
    }

    default public void replacePartitionMetadata(InternalRow ident, java.util.Map<String, String> properties) {
        throw new UnsupportedOperationException("Replace partition is not supported");
    }

    public static /* synthetic */ java.util.Map loadPartitionMetadata$(PaimonPartitionManagement $this, InternalRow ident) {
        return $this.loadPartitionMetadata(ident);
    }

    default public java.util.Map<String, String> loadPartitionMetadata(InternalRow ident) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
    }

    public static /* synthetic */ InternalRow[] listPartitionIdentifiers$(PaimonPartitionManagement $this, String[] partitionCols, InternalRow internalRow) {
        return $this.listPartitionIdentifiers(partitionCols, internalRow);
    }

    default public InternalRow[] listPartitionIdentifiers(String[] partitionCols, InternalRow internalRow) {
        Predef$.MODULE$.assert(partitionCols.length == internalRow.numFields(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Number of partition names (").append(partitionCols.length).append(") must be equal to ").append("the number of partition values (").append(internalRow.numFields()).append(").").toString());
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionCols)).forall((Function1 & Serializable & scala.Serializable)fieldName -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$2(this, fieldName))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Some partition names ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionCols)).mkString("[", ", ", "]")).append(" don't belong to ").append("the partition schema '").append(this.partitionSchema().sql()).append("'.").toString());
        return (InternalRow[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((SparkTable)this).table().newReadBuilder().newScan().listPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)binaryRow -> DataConverter.fromPaimon(binaryRow, this.partitionRowType()), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)sparkInternalRow -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$5(this, partitionCols, internalRow, sparkInternalRow)))).toArray(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public static /* synthetic */ void createPartitions$(PaimonPartitionManagement $this, InternalRow[] rows, java.util.Map[] maps) {
        $this.createPartitions(rows, maps);
    }

    default public void createPartitions(InternalRow[] rows, java.util.Map<String, String>[] maps) {
        Table table = ((SparkTable)this).table();
        if (table instanceof FileStoreTable) {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            java.util.Map<String, String>[] partitions = this.toPaimonPartitions(rows);
            PartitionHandler partitionHandler = fileStoreTable.catalogEnvironment().partitionHandler();
            if (partitionHandler != null) {
                try {
                    BoxedUnit boxedUnit;
                    if (fileStoreTable.coreOptions().partitionedTableInMetastore()) {
                        partitionHandler.createPartitions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).toSeq()).asJava());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                finally {
                    partitionHandler.close();
                }
                return;
            }
            return;
        }
        throw new UnsupportedOperationException("Only FileStoreTable supports create partitions.");
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$2(PaimonPartitionManagement $this, String fieldName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionSchema().fieldNames())).contains((Object)fieldName);
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$6(PaimonPartitionManagement $this, InternalRow sparkInternalRow$1, InternalRow internalRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String partitionName = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int internalRowIndex = $this.partitionSchema().fieldIndex(partitionName);
            StructField structField = $this.partitionSchema().fields()[internalRowIndex];
            return Objects.equals(sparkInternalRow$1.get(internalRowIndex, structField.dataType()), internalRow$1.get(index, structField.dataType()));
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$7(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static /* synthetic */ boolean $anonfun$listPartitionIdentifiers$5(PaimonPartitionManagement $this, String[] partitionCols$1, InternalRow internalRow$1, InternalRow sparkInternalRow) {
        return new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionCols$1)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$6($this, sparkInternalRow, internalRow$1, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)PaimonPartitionManagement.$anonfun$listPartitionIdentifiers$7(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public static void $init$(PaimonPartitionManagement $this) {
    }
}

