/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.view.ViewChange;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class AlterViewDialectProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("view", DataTypes.StringType), ProcedureParameter.required("action", DataTypes.StringType), ProcedureParameter.optional("engine", DataTypes.StringType), ProcedureParameter.optional("query", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected AlterViewDialectProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        ViewChange viewChange;
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        Identifier ident = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        org.apache.paimon.catalog.Identifier view = CatalogUtils.toIdentifier(ident);
        String dialect = ((GenericInternalRow)args2).genericGet(2) == null || StringUtils.isNullOrWhitespaceOnly(args2.getString(2)) ? "spark" : args2.getString(2);
        String query = ((GenericInternalRow)args2).genericGet(3) == null ? null : args2.getString(3);
        switch (args2.getString(1)) {
            case "add": {
                if (StringUtils.isNullOrWhitespaceOnly(query)) {
                    throw new IllegalArgumentException("query is required for add action.");
                }
                viewChange = ViewChange.addDialect(dialect, query);
                break;
            }
            case "update": {
                if (StringUtils.isNullOrWhitespaceOnly(query)) {
                    throw new IllegalArgumentException("query is required for update action.");
                }
                viewChange = ViewChange.updateDialect(dialect, query);
                break;
            }
            case "drop": {
                viewChange = ViewChange.dropDialect(dialect);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action: " + args2.getString(1));
            }
        }
        try {
            paimonCatalog.alterView(view, ImmutableList.of(viewChange), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<AlterViewDialectProcedure>(){

            @Override
            public AlterViewDialectProcedure doBuild() {
                return new AlterViewDialectProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "AlterViewDialectProcedure";
    }
}

