/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.HashMap;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.ProcedureUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class ExpireSnapshotsProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("retain_max", DataTypes.IntegerType), ProcedureParameter.optional("retain_min", DataTypes.IntegerType), ProcedureParameter.optional("older_than", DataTypes.StringType), ProcedureParameter.optional("max_deletes", DataTypes.IntegerType), ProcedureParameter.optional("options", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("deleted_snapshots_count", DataTypes.IntegerType, false, Metadata.empty())});

    protected ExpireSnapshotsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        Integer retainMax = args2.isNullAt(1) ? null : Integer.valueOf(args2.getInt(1));
        Integer retainMin = args2.isNullAt(2) ? null : Integer.valueOf(args2.getInt(2));
        String olderThanStr = args2.isNullAt(3) ? null : args2.getString(3);
        Integer maxDeletes = args2.isNullAt(4) ? null : Integer.valueOf(args2.getInt(4));
        String options = args2.isNullAt(5) ? null : args2.getString(5);
        return this.modifyPaimonTable(tableIdent, table -> {
            HashMap<String, String> dynamicOptions = new HashMap<String, String>();
            ProcedureUtils.putAllOptions(dynamicOptions, options);
            table = table.copy(dynamicOptions);
            ExpireSnapshots expireSnapshots = table.newExpireSnapshots();
            CoreOptions tableOptions = ((FileStoreTable)table).store().options();
            ExpireConfig.Builder builder = ProcedureUtils.fillInSnapshotOptions(tableOptions, retainMax, retainMin, olderThanStr, maxDeletes);
            int deleted = expireSnapshots.config(builder.build()).expire();
            return new InternalRow[]{this.newInternalRow(deleted)};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ExpireSnapshotsProcedure>(){

            @Override
            public ExpireSnapshotsProcedure doBuild() {
                return new ExpireSnapshotsProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ExpireSnapshotsProcedure";
    }
}

