/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal.connector;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.sources.AlwaysFalse;
import org.apache.spark.sql.sources.AlwaysTrue;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PredicateUtils$ {
    public static PredicateUtils$ MODULE$;

    static {
        new PredicateUtils$();
    }

    public Option<Filter> toV1(Predicate predicate) {
        String string = predicate.name();
        if ("IN".equals(string) && predicate.children()[0] instanceof NamedReference) {
            String attribute = predicate.children()[0].toString();
            Expression[] values2 = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicate.children())).drop(1);
            if (values2.length > 0) {
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values2)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PredicateUtils$.$anonfun$toV1$1(x$1)))) {
                    return None$.MODULE$;
                }
                DataType dataType = ((LiteralValue)values2[0]).dataType();
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values2)).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PredicateUtils$.$anonfun$toV1$2(dataType, x$2)))) {
                    return None$.MODULE$;
                }
                Object[] inValues = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values2)).map((Function1 & Serializable & scala.Serializable)v -> CatalystTypeConverters$.MODULE$.convertToScala(((LiteralValue)v).value(), dataType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                return new Some((Object)new In(attribute, inValues));
            }
            return new Some((Object)new In(attribute, (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Any())));
        }
        if (("=".equals(string) ? true : ("<=>".equals(string) ? true : (">".equals(string) ? true : ("<".equals(string) ? true : (">=".equals(string) ? true : "<=".equals(string)))))) && PredicateUtils$.isValidBinaryPredicate$1(predicate)) {
            EqualTo equalTo;
            String attribute = predicate.children()[0].toString();
            LiteralValue value = (LiteralValue)predicate.children()[1];
            Object v1Value = CatalystTypeConverters$.MODULE$.convertToScala(value.value(), value.dataType());
            String string2 = predicate.name();
            if ("=".equals(string2)) {
                equalTo = new EqualTo(attribute, v1Value);
            } else if ("<=>".equals(string2)) {
                equalTo = new EqualNullSafe(attribute, v1Value);
            } else if (">".equals(string2)) {
                equalTo = new GreaterThan(attribute, v1Value);
            } else if (">=".equals(string2)) {
                equalTo = new GreaterThanOrEqual(attribute, v1Value);
            } else if ("<".equals(string2)) {
                equalTo = new LessThan(attribute, v1Value);
            } else if ("<=".equals(string2)) {
                equalTo = new LessThanOrEqual(attribute, v1Value);
            } else {
                throw new MatchError((Object)string2);
            }
            EqualTo v1Filter = equalTo;
            return new Some((Object)v1Filter);
        }
        if (("IS_NULL".equals(string) ? true : "IS_NOT_NULL".equals(string)) && predicate.children().length == 1 && predicate.children()[0] instanceof NamedReference) {
            IsNull isNull;
            String attribute = predicate.children()[0].toString();
            String string3 = predicate.name();
            if ("IS_NULL".equals(string3)) {
                isNull = new IsNull(attribute);
            } else if ("IS_NOT_NULL".equals(string3)) {
                isNull = new IsNotNull(attribute);
            } else {
                throw new MatchError((Object)string3);
            }
            IsNull v1Filter = isNull;
            return new Some((Object)v1Filter);
        }
        if (("STARTS_WITH".equals(string) ? true : ("ENDS_WITH".equals(string) ? true : "CONTAINS".equals(string))) && PredicateUtils$.isValidBinaryPredicate$1(predicate)) {
            StringStartsWith stringStartsWith;
            String attribute = predicate.children()[0].toString();
            LiteralValue value = (LiteralValue)predicate.children()[1];
            if (!value.dataType().sameType((DataType)StringType$.MODULE$)) {
                return None$.MODULE$;
            }
            String v1Value = value.value().toString();
            String string4 = predicate.name();
            if ("STARTS_WITH".equals(string4)) {
                stringStartsWith = new StringStartsWith(attribute, v1Value);
            } else if ("ENDS_WITH".equals(string4)) {
                stringStartsWith = new StringEndsWith(attribute, v1Value);
            } else if ("CONTAINS".equals(string4)) {
                stringStartsWith = new StringContains(attribute, v1Value);
            } else {
                throw new MatchError((Object)string4);
            }
            StringStartsWith v1Filter = stringStartsWith;
            return new Some((Object)v1Filter);
        }
        if (("ALWAYS_TRUE".equals(string) ? true : "ALWAYS_FALSE".equals(string)) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicate.children())).isEmpty()) {
            AlwaysTrue alwaysTrue;
            String string5 = predicate.name();
            if ("ALWAYS_TRUE".equals(string5)) {
                alwaysTrue = new AlwaysTrue();
            } else if ("ALWAYS_FALSE".equals(string5)) {
                alwaysTrue = new AlwaysFalse();
            } else {
                throw new MatchError((Object)string5);
            }
            AlwaysTrue v1Filter = alwaysTrue;
            return new Some((Object)v1Filter);
        }
        if ("AND".equals(string)) {
            And and = (And)predicate;
            Option<Filter> left = this.toV1(and.left());
            Option<Filter> right = this.toV1(and.right());
            if (left.nonEmpty() && right.nonEmpty()) {
                return new Some((Object)new org.apache.spark.sql.sources.And((Filter)left.get(), (Filter)right.get()));
            }
            return None$.MODULE$;
        }
        if ("OR".equals(string)) {
            org.apache.spark.sql.connector.expressions.filter.Or or = (org.apache.spark.sql.connector.expressions.filter.Or)predicate;
            Option<Filter> left = this.toV1(or.left());
            Option<Filter> right = this.toV1(or.right());
            if (left.nonEmpty() && right.nonEmpty()) {
                return new Some((Object)new Or((Filter)left.get(), (Filter)right.get()));
            }
            if (left.nonEmpty()) {
                return left;
            }
            return right;
        }
        if ("NOT".equals(string)) {
            Option<Filter> child = this.toV1(((Not)predicate).child());
            if (child.nonEmpty()) {
                return new Some((Object)new org.apache.spark.sql.sources.Not((Filter)child.get()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Filter[] toV1(Predicate[] predicates) {
        return (Filter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(MODULE$.toV1((Predicate)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Filter.class)));
    }

    private static final boolean isValidBinaryPredicate$1(Predicate predicate$1) {
        return predicate$1.children().length == 2 && predicate$1.children()[0] instanceof NamedReference && predicate$1.children()[1] instanceof LiteralValue;
    }

    public static final /* synthetic */ boolean $anonfun$toV1$1(Expression x$1) {
        return x$1 instanceof LiteralValue;
    }

    public static final /* synthetic */ boolean $anonfun$toV1$2(DataType dataType$1, Expression x$2) {
        return ((LiteralValue)x$2).dataType().sameType(dataType$1);
    }

    private PredicateUtils$() {
        MODULE$ = this;
    }
}

