/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestEntrySerializer;
import org.apache.paimon.manifest.IndexManifestFileHandler;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class IndexManifestFile
extends ObjectsFile<IndexManifestEntry> {
    private IndexManifestFile(FileIO fileIO, RowType schema, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, String compression, PathFactory pathFactory, @Nullable SegmentsCache<Path> cache) {
        super(fileIO, new IndexManifestEntrySerializer(), schema, readerFactory, writerFactory, compression, pathFactory, cache);
    }

    @Nullable
    public String writeIndexFiles(@Nullable String previousIndexManifest, List<IndexManifestEntry> newIndexFiles, BucketMode bucketMode) {
        if (newIndexFiles.isEmpty()) {
            return previousIndexManifest;
        }
        IndexManifestFileHandler handler = new IndexManifestFileHandler(this, bucketMode);
        return handler.write(previousIndexManifest, newIndexFiles);
    }

    public static class Factory {
        private final FileIO fileIO;
        private final FileFormat fileFormat;
        private final String compression;
        private final FileStorePathFactory pathFactory;
        @Nullable
        private final SegmentsCache<Path> cache;

        public Factory(FileIO fileIO, FileFormat fileFormat, String compression, FileStorePathFactory pathFactory, @Nullable SegmentsCache<Path> cache) {
            this.fileIO = fileIO;
            this.fileFormat = fileFormat;
            this.compression = compression;
            this.pathFactory = pathFactory;
            this.cache = cache;
        }

        public IndexManifestFile create() {
            RowType schema = VersionedObjectSerializer.versionType(IndexManifestEntry.SCHEMA);
            return new IndexManifestFile(this.fileIO, schema, this.fileFormat.createReaderFactory(schema, schema, new ArrayList<Predicate>()), this.fileFormat.createWriterFactory(schema), this.compression, this.pathFactory.indexManifestFileFactory(), this.cache);
        }
    }
}

