/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.TableType;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.DelegateCatalog;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.format.csv.CsvOptions;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionDefinition;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalog;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.spark.LambdaScalarFunction;
import org.apache.paimon.spark.SparkCatalogOptions;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.catalog.FormatTableCatalog;
import org.apache.paimon.spark.catalog.SparkBaseCatalog;
import org.apache.paimon.spark.catalog.SupportV1Function;
import org.apache.paimon.spark.catalog.SupportView;
import org.apache.paimon.spark.catalog.functions.PaimonFunctions;
import org.apache.paimon.spark.catalog.functions.V1FunctionConverter;
import org.apache.paimon.spark.util.OptionUtils;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.ExceptionUtils;
import org.apache.paimon.utils.TypeUtils;
import org.apache.spark.sql.PaimonSparkSession$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.PaimonV1FunctionRegistry;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.extensions.UnResolvedPaimonV1Function;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.PartitionedCSVTable;
import org.apache.spark.sql.execution.PartitionedJsonTable;
import org.apache.spark.sql.execution.PartitionedOrcTable;
import org.apache.spark.sql.execution.PartitionedParquetTable;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkCatalog
extends SparkBaseCatalog
implements SupportView,
SupportV1Function,
FunctionCatalog,
SupportsNamespaces,
FormatTableCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(SparkCatalog.class);
    public static final String FUNCTION_DEFINITION_NAME = "spark";
    private static final String PRIMARY_KEY_IDENTIFIER = "primary-key";
    private Catalog catalog;
    private String defaultDatabase;
    private boolean v1FunctionEnabled;
    @Nullable
    private PaimonV1FunctionRegistry v1FunctionRegistry;

    public void initialize(String name, CaseInsensitiveStringMap options) {
        OptionUtils.checkRequiredConfigurations();
        SparkSession sparkSession = PaimonSparkSession$.MODULE$.active();
        this.catalogName = name;
        CatalogContext catalogContext = CatalogContext.create(Options.fromMap((Map<String, String>)options), sparkSession.sessionState().newHadoopConf());
        this.catalog = CatalogFactory.createCatalog(catalogContext);
        this.defaultDatabase = (String)options.getOrDefault((Object)SparkCatalogOptions.DEFAULT_DATABASE.key(), (Object)SparkCatalogOptions.DEFAULT_DATABASE.defaultValue());
        boolean bl = this.v1FunctionEnabled = options.getBoolean(SparkCatalogOptions.V1FUNCTION_ENABLED.key(), SparkCatalogOptions.V1FUNCTION_ENABLED.defaultValue().booleanValue()) && DelegateCatalog.rootCatalog(this.catalog) instanceof RESTCatalog;
        if (this.v1FunctionEnabled) {
            this.v1FunctionRegistry = new PaimonV1FunctionRegistry(sparkSession);
        }
        try {
            this.catalog.getDatabase(this.defaultDatabase);
        }
        catch (Catalog.DatabaseNotExistException e) {
            LOG.info("Default database '{}' does not exist, caused by: {}, start to create it", (Object)this.defaultDatabase, (Object)ExceptionUtils.stringifyException(e));
            try {
                this.createNamespace(this.defaultNamespace(), new HashMap<String, String>());
            }
            catch (NamespaceAlreadyExistsException namespaceAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public Catalog paimonCatalog() {
        return this.catalog;
    }

    public String[] defaultNamespace() {
        return new String[]{this.defaultDatabase};
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            this.catalog.createDatabase(databaseName, false, metadata);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new NamespaceAlreadyExistsException(namespace);
        }
    }

    public String[][] listNamespaces() {
        List<String> databases = this.catalog.listDatabases();
        String[][] namespaces = new String[databases.size()][];
        for (int i = 0; i < databases.size(); ++i) {
            namespaces[i] = new String[]{databases.get(i)};
        }
        return namespaces;
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        if (namespace.length == 0) {
            return this.listNamespaces();
        }
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            this.catalog.getDatabase(databaseName);
            return new String[0][];
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            return this.catalog.getDatabase(databaseName).options();
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public boolean dropNamespace(String[] namespace) throws NoSuchNamespaceException {
        return this.dropNamespace(namespace, false);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            this.catalog.dropDatabase(databaseName, false, cascade);
            return true;
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new UnsupportedOperationException(String.format("Namespace %s is not empty", Arrays.toString(namespace)));
        }
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            List<PropertyChange> propertyChanges = Arrays.stream(changes).map(this::toPropertyChange).collect(Collectors.toList());
            this.catalog.alterDatabase(databaseName, propertyChanges, false);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        CatalogUtils.checkNamespace(namespace);
        try {
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            return (Identifier[])this.catalog.listTables(databaseName).stream().map(table -> Identifier.of((String[])namespace, (String)table)).toArray(Identifier[]::new);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public void invalidateTable(Identifier ident) {
        this.catalog.invalidateTable(CatalogUtils.toIdentifier(ident));
    }

    public org.apache.spark.sql.connector.catalog.Table loadTable(Identifier ident) throws NoSuchTableException {
        return this.loadSparkTable(ident, Collections.emptyMap());
    }

    public SparkTable loadTable(Identifier ident, String version) throws NoSuchTableException {
        LOG.info("Time travel to version '{}'.", (Object)version);
        org.apache.spark.sql.connector.catalog.Table table = this.loadSparkTable(ident, Collections.singletonMap(CoreOptions.SCAN_VERSION.key(), version));
        if (table instanceof SparkTable) {
            return (SparkTable)table;
        }
        throw new NoSuchTableException(ident);
    }

    public SparkTable loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        LOG.info("Time travel target timestamp is {} milliseconds.", (Object)(timestamp /= 1000L));
        org.apache.spark.sql.connector.catalog.Table table = this.loadSparkTable(ident, Collections.singletonMap(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), String.valueOf(timestamp)));
        if (table instanceof SparkTable) {
            return (SparkTable)table;
        }
        throw new NoSuchTableException(ident);
    }

    public org.apache.spark.sql.connector.catalog.Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        List<SchemaChange> schemaChanges = Arrays.stream(changes).map(this::toSchemaChange).collect(Collectors.toList());
        try {
            this.catalog.alterTable(CatalogUtils.toIdentifier(ident), schemaChanges, false);
            return this.loadTable(ident);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(ident);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    public org.apache.spark.sql.connector.catalog.Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        try {
            this.catalog.createTable(CatalogUtils.toIdentifier(ident), this.toInitialSchema(schema, partitions, properties), false);
            return this.loadTable(ident);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException(ident);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(ident.namespace());
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropTable(Identifier ident) {
        try {
            this.catalog.dropTable(CatalogUtils.toIdentifier(ident), false);
            return true;
        }
        catch (Catalog.TableNotExistException e) {
            return false;
        }
    }

    private SchemaChange toSchemaChange(TableChange change) {
        if (change instanceof TableChange.SetProperty) {
            TableChange.SetProperty set = (TableChange.SetProperty)change;
            this.validateAlterProperty(set.property());
            if (set.property().equals("comment")) {
                return SchemaChange.updateComment(set.value());
            }
            return SchemaChange.setOption(set.property(), set.value());
        }
        if (change instanceof TableChange.RemoveProperty) {
            TableChange.RemoveProperty remove = (TableChange.RemoveProperty)change;
            this.validateAlterProperty(remove.property());
            if (remove.property().equals("comment")) {
                return SchemaChange.updateComment(null);
            }
            return SchemaChange.removeOption(remove.property());
        }
        if (change instanceof TableChange.AddColumn) {
            TableChange.AddColumn add = (TableChange.AddColumn)change;
            SchemaChange.Move move = SparkCatalog.getMove(add.position(), add.fieldNames());
            CatalogUtils.checkNoDefaultValue(add);
            return SchemaChange.addColumn(add.fieldNames(), SparkTypeUtils.toPaimonType(add.dataType()).copy(add.isNullable()), add.comment(), move);
        }
        if (change instanceof TableChange.RenameColumn) {
            TableChange.RenameColumn rename = (TableChange.RenameColumn)change;
            return SchemaChange.renameColumn(rename.fieldNames(), rename.newName());
        }
        if (change instanceof TableChange.DeleteColumn) {
            TableChange.DeleteColumn delete = (TableChange.DeleteColumn)change;
            return SchemaChange.dropColumn(delete.fieldNames());
        }
        if (change instanceof TableChange.UpdateColumnType) {
            TableChange.UpdateColumnType update = (TableChange.UpdateColumnType)change;
            return SchemaChange.updateColumnType(update.fieldNames(), SparkTypeUtils.toPaimonType(update.newDataType()), true);
        }
        if (change instanceof TableChange.UpdateColumnNullability) {
            TableChange.UpdateColumnNullability update = (TableChange.UpdateColumnNullability)change;
            return SchemaChange.updateColumnNullability(update.fieldNames(), update.nullable());
        }
        if (change instanceof TableChange.UpdateColumnComment) {
            TableChange.UpdateColumnComment update = (TableChange.UpdateColumnComment)change;
            return SchemaChange.updateColumnComment(update.fieldNames(), update.newComment());
        }
        if (change instanceof TableChange.UpdateColumnPosition) {
            TableChange.UpdateColumnPosition update = (TableChange.UpdateColumnPosition)change;
            SchemaChange.Move move = SparkCatalog.getMove(update.position(), update.fieldNames());
            return SchemaChange.updateColumnPosition(move);
        }
        if (CatalogUtils.isUpdateColumnDefaultValue(change)) {
            return CatalogUtils.toUpdateColumnDefaultValue(change);
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    private static SchemaChange.Move getMove(TableChange.ColumnPosition columnPosition, String[] fieldNames) {
        SchemaChange.Move move = null;
        if (columnPosition instanceof TableChange.First) {
            move = SchemaChange.Move.first(fieldNames[0]);
        } else if (columnPosition instanceof TableChange.After) {
            move = SchemaChange.Move.after(fieldNames[0], ((TableChange.After)columnPosition).column());
        }
        return move;
    }

    private Schema toInitialSchema(StructType schema, Transform[] partitions, Map<String, String> properties) {
        String pkAsString;
        HashMap<String, String> normalizedProperties = new HashMap<String, String>(properties);
        String provider = properties.get("provider");
        if (!SparkCatalog.usePaimon(provider)) {
            if (this.isFormatTable(provider)) {
                normalizedProperties.put(CoreOptions.TYPE.key(), TableType.FORMAT_TABLE.toString());
                normalizedProperties.put(CoreOptions.FILE_FORMAT.key(), provider.toLowerCase());
            } else {
                throw new UnsupportedOperationException("Provider is not supported: " + provider);
            }
        }
        normalizedProperties.remove("provider");
        normalizedProperties.remove(PRIMARY_KEY_IDENTIFIER);
        normalizedProperties.remove("comment");
        if (normalizedProperties.containsKey("location")) {
            String path = (String)normalizedProperties.remove("location");
            normalizedProperties.put(CoreOptions.PATH.key(), path);
        }
        List<String> primaryKeys = (pkAsString = properties.get(PRIMARY_KEY_IDENTIFIER)) == null ? Collections.emptyList() : Arrays.stream(pkAsString.split(",")).map(String::trim).collect(Collectors.toList());
        Schema.Builder schemaBuilder = Schema.newBuilder().options(normalizedProperties).primaryKey(primaryKeys).partitionKeys(this.convertPartitionTransforms(partitions)).comment(properties.getOrDefault("comment", null));
        for (StructField field : schema.fields()) {
            String name = field.name();
            DataType type = SparkTypeUtils.toPaimonType(field.dataType()).copy(field.nullable());
            String comment = (String)field.getComment().getOrElse(() -> null);
            if (field.metadata().contains("CURRENT_DEFAULT")) {
                String defaultValue = field.metadata().getString("CURRENT_DEFAULT");
                schemaBuilder.column(name, type, comment, defaultValue);
                continue;
            }
            schemaBuilder.column(name, type, comment);
        }
        return schemaBuilder.build();
    }

    private void validateAlterProperty(String alterKey) {
        if (PRIMARY_KEY_IDENTIFIER.equals(alterKey)) {
            throw new UnsupportedOperationException("Alter primary key is not supported");
        }
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        try {
            this.catalog.renameTable(CatalogUtils.toIdentifier(oldIdent), CatalogUtils.toIdentifier(CatalogUtils.removeCatalogName(newIdent, this.catalogName)), false);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(oldIdent);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException(newIdent);
        }
    }

    public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        if (this.isSystemFunctionNamespace(namespace)) {
            ArrayList result = new ArrayList();
            PaimonFunctions.names().forEach(name -> result.add(Identifier.of((String[])namespace, (String)name)));
            return result.toArray(new Identifier[0]);
        }
        if (this.isDatabaseFunctionNamespace(namespace)) {
            ArrayList result = new ArrayList();
            String databaseName = this.getDatabaseNameFromNamespace(namespace);
            try {
                this.catalog.listFunctions(databaseName).forEach(name -> result.add(Identifier.of((String[])namespace, (String)name)));
            }
            catch (Catalog.DatabaseNotExistException e) {
                throw new NoSuchNamespaceException(namespace);
            }
            return result.toArray(new Identifier[0]);
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        String[] namespace = ident.namespace();
        if (this.isSystemFunctionNamespace(namespace)) {
            UnboundFunction func = PaimonFunctions.load(ident.name());
            if (func != null) {
                return func;
            }
        } else if (this.isDatabaseFunctionNamespace(namespace)) {
            try {
                Function paimonFunction = this.catalog.getFunction(CatalogUtils.toIdentifier(ident));
                FunctionDefinition functionDefinition = paimonFunction.definition(FUNCTION_DEFINITION_NAME);
                if (functionDefinition instanceof FunctionDefinition.LambdaFunctionDefinition) {
                    FunctionDefinition.LambdaFunctionDefinition lambdaFunctionDefinition = (FunctionDefinition.LambdaFunctionDefinition)functionDefinition;
                    if (paimonFunction.returnParams().isPresent()) {
                        List<DataField> dataFields = paimonFunction.returnParams().get();
                        if (dataFields.size() == 1) {
                            DataField dataField = dataFields.get(0);
                            return new LambdaScalarFunction(ident.name(), CatalogUtils.paimonType2SparkType(dataField.type()), CatalogUtils.paimonType2JavaType(dataField.type()), lambdaFunctionDefinition.definition());
                        }
                        throw new UnsupportedOperationException("outParams size > 1 is not supported");
                    }
                }
            }
            catch (Catalog.FunctionNotExistException e) {
                throw new NoSuchFunctionException(ident);
            }
        }
        throw new NoSuchFunctionException(ident);
    }

    private boolean isSystemFunctionNamespace(String[] namespace) {
        return namespace.length == 0 || SparkCatalog.isSystemNamespace(namespace);
    }

    private boolean isDatabaseFunctionNamespace(String[] namespace) {
        return namespace.length == 1 && this.namespaceExists(namespace);
    }

    private PaimonV1FunctionRegistry v1FunctionRegistry() {
        assert (this.v1FunctionRegistry != null);
        return this.v1FunctionRegistry;
    }

    @Override
    public boolean v1FunctionEnabled() {
        return this.v1FunctionEnabled;
    }

    @Override
    public Function getFunction(FunctionIdentifier funcIdent) throws Exception {
        return this.paimonCatalog().getFunction(V1FunctionConverter.fromFunctionIdentifier(funcIdent));
    }

    @Override
    public void createV1Function(CatalogFunction v1Function, boolean ignoreIfExists) throws Exception {
        Function paimonFunction = V1FunctionConverter.fromV1Function(v1Function);
        this.paimonCatalog().createFunction(V1FunctionConverter.fromFunctionIdentifier(v1Function.identifier()), paimonFunction, ignoreIfExists);
    }

    @Override
    public boolean v1FunctionRegistered(FunctionIdentifier funcIdent) {
        return this.v1FunctionRegistry().isRegistered(funcIdent);
    }

    @Override
    public Expression registerAndResolveV1Function(UnResolvedPaimonV1Function unresolvedV1Function) {
        return this.v1FunctionRegistry().registerAndResolveFunction(unresolvedV1Function);
    }

    @Override
    public void dropV1Function(FunctionIdentifier funcIdent, boolean ifExists) throws Exception {
        this.v1FunctionRegistry().unregisterFunction(funcIdent);
        this.paimonCatalog().dropFunction(V1FunctionConverter.fromFunctionIdentifier(funcIdent), ifExists);
    }

    protected org.apache.spark.sql.connector.catalog.Table loadSparkTable(Identifier ident, Map<String, String> extraOptions) throws NoSuchTableException {
        try {
            Table paimonTable = this.catalog.getTable(CatalogUtils.toIdentifier(ident));
            if (paimonTable instanceof FormatTable) {
                return SparkCatalog.convertToFileTable(ident, (FormatTable)paimonTable);
            }
            return new SparkTable(OptionUtils.copyWithSQLConf(paimonTable, this.catalogName, CatalogUtils.toIdentifier(ident), extraOptions));
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(ident);
        }
    }

    private static FileTable convertToFileTable(Identifier ident, FormatTable formatTable) {
        SparkSession spark = PaimonSparkSession$.MODULE$.active();
        StructType schema = SparkTypeUtils.fromPaimonRowType(formatTable.rowType());
        StructType partitionSchema = SparkTypeUtils.fromPaimonRowType(TypeUtils.project(formatTable.rowType(), formatTable.partitionKeys()));
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(formatTable.location());
        Options options = Options.fromMap(formatTable.options());
        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(options.toMap());
        if (formatTable.format() == FormatTable.Format.CSV) {
            options.set("sep", options.get(CsvOptions.FIELD_DELIMITER));
            dsOptions = new CaseInsensitiveStringMap(options.toMap());
            return new PartitionedCSVTable(ident.name(), spark, dsOptions, (Seq<String>)JavaConverters.asScalaBuffer(pathList).toSeq(), (Option<StructType>)Option.apply((Object)schema), CSVFileFormat.class, partitionSchema);
        }
        if (formatTable.format() == FormatTable.Format.ORC) {
            return new PartitionedOrcTable(ident.name(), spark, dsOptions, (Seq<String>)JavaConverters.asScalaBuffer(pathList).toSeq(), (Option<StructType>)Option.apply((Object)schema), OrcFileFormat.class, partitionSchema);
        }
        if (formatTable.format() == FormatTable.Format.PARQUET) {
            return new PartitionedParquetTable(ident.name(), spark, dsOptions, (Seq<String>)JavaConverters.asScalaBuffer(pathList).toSeq(), (Option<StructType>)Option.apply((Object)schema), ParquetFileFormat.class, partitionSchema);
        }
        if (formatTable.format() == FormatTable.Format.JSON) {
            return new PartitionedJsonTable(ident.name(), spark, dsOptions, (Seq<String>)JavaConverters.asScalaBuffer(pathList).toSeq(), (Option<StructType>)Option.apply((Object)schema), JsonFileFormat.class, partitionSchema);
        }
        throw new UnsupportedOperationException("Unsupported format table " + ident.name() + " format " + formatTable.format().name());
    }

    protected List<String> convertPartitionTransforms(Transform[] transforms) {
        ArrayList<String> partitionColNames = new ArrayList<String>(transforms.length);
        for (Transform transform : transforms) {
            if (!(transform instanceof IdentityTransform)) {
                throw new UnsupportedOperationException("Unsupported partition transform: " + transform);
            }
            NamedReference ref = ((IdentityTransform)transform).ref();
            if (!(ref instanceof FieldReference) && ref.fieldNames().length == 1) {
                throw new UnsupportedOperationException("Unsupported partition transform: " + transform);
            }
            partitionColNames.add(ref.fieldNames()[0]);
        }
        return partitionColNames;
    }

    private PropertyChange toPropertyChange(NamespaceChange change) {
        if (change instanceof NamespaceChange.SetProperty) {
            NamespaceChange.SetProperty set = (NamespaceChange.SetProperty)change;
            return PropertyChange.setProperty(set.property(), set.value());
        }
        if (change instanceof NamespaceChange.RemoveProperty) {
            NamespaceChange.RemoveProperty remove = (NamespaceChange.RemoveProperty)change;
            return PropertyChange.removeProperty(remove.property());
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    private String getDatabaseNameFromNamespace(String[] namespace) {
        return namespace[0];
    }
}

