/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.commands;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.crosspartition.IndexBootstrap;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.SimpleHashBucketAssigner;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTableWrite;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.catalog.functions.BucketFunction$;
import org.apache.paimon.spark.commands.BucketExpression$;
import org.apache.paimon.spark.commands.BucketProcessor;
import org.apache.paimon.spark.commands.CommonBucketProcessor;
import org.apache.paimon.spark.commands.DynamicBucketProcessor;
import org.apache.paimon.spark.commands.EncoderSerDeGroup;
import org.apache.paimon.spark.commands.GlobalDynamicBucketProcessor;
import org.apache.paimon.spark.commands.PaimonSparkWriter$;
import org.apache.paimon.spark.commands.PaimonSparkWriter$ModPartitioner$;
import org.apache.paimon.spark.commands.SparkDeletionVector;
import org.apache.paimon.spark.schema.SparkSystemColumns$;
import org.apache.paimon.spark.sort.TableSorter;
import org.apache.paimon.spark.util.OptionUtils$;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.spark.write.WriteHelper;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rb\u0001B!C\u00016C\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005E\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011\u0015q\u0007\u0001\"\u0001p\u0011!!\b\u0001#b\u0001\n\u0013)\b\u0002\u0003?\u0001\u0011\u000b\u0007I\u0011B?\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0013\t)\u0001C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u00111\u0006\u0001!\u0002\u0013\ty\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u00020!A\u0011q\u0007\u0001!\u0002\u0013\t\t\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002<!1q\u000b\u0001C\u0001\u0003\u007fAq!!\"\u0001\t\u0003\t9\tC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011q\u001f\u0001\u0005\n\u0005e\bb\u0002B\u0007\u0001\u0011%!q\u0002\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005K1aA!\f\u0001\t\n=\u0002B\u0003B\u001d/\tU\r\u0011\"\u0001\u0003<!Q!QH\f\u0003\u0012\u0003\u0006I!!;\t\r9<B\u0011\u0001B \u0011\u001d\u00119e\u0006C!\u0005wAqA!\u0013\u0018\t\u0003\u0012Y\u0005C\u0005\u0003X]\t\t\u0011\"\u0001\u0003Z!I!QL\f\u0012\u0002\u0013\u0005!q\f\u0005\n\u0005k:\u0012\u0011!C!\u0005oB\u0011B!#\u0018\u0003\u0003%\tAa\u000f\t\u0013\t-u#!A\u0005\u0002\t5\u0005\"\u0003BJ/\u0005\u0005I\u0011\tBK\u0011%\u0011\u0019kFA\u0001\n\u0003\u0011)\u000bC\u0005\u0003*^\t\t\u0011\"\u0011\u0003,\"I!QV\f\u0002\u0002\u0013\u0005#q\u0016\u0005\n\u0005c;\u0012\u0011!C!\u0005g;\u0011Ba.\u0001\u0003\u0003EIA!/\u0007\u0013\t5\u0002!!A\t\n\tm\u0006B\u00028)\t\u0003\u0011I\rC\u0005\u0003.\"\n\t\u0011\"\u0012\u00030\"I!1\u001a\u0015\u0002\u0002\u0013\u0005%Q\u001a\u0005\n\u0005#D\u0013\u0011!CA\u0005'D\u0011Ba\u0016\u0001\u0003\u0003%\tAa8\t\u0013\tu\u0003!%A\u0005\u0002\t\u0015\b\"\u0003Bu\u0001E\u0005I\u0011\u0001Bv\u0011%\u0011)\bAA\u0001\n\u0003\u00129\bC\u0005\u0003\n\u0002\t\t\u0011\"\u0001\u0003<!I!1\u0012\u0001\u0002\u0002\u0013\u0005!q\u001e\u0005\n\u0005'\u0003\u0011\u0011!C!\u0005+C\u0011Ba)\u0001\u0003\u0003%\tAa=\t\u0013\t%\u0006!!A\u0005B\t-\u0006\"\u0003BW\u0001\u0005\u0005I\u0011\tBX\u0011%\u0011\t\fAA\u0001\n\u0003\u00129pB\u0004\u0003|\nC\tA!@\u0007\r\u0005\u0013\u0005\u0012\u0001B\u0000\u0011\u0019q\u0017\b\"\u0001\u0004\u0002!9!1Z\u001d\u0005\u0002\r\r\u0001\"\u0003Bfs\u0005\u0005I\u0011QB\u0004\u0011%\u0019i!OI\u0001\n\u0003\u0011Y\u000fC\u0005\u0003Rf\n\t\u0011\"!\u0004\u0010!I1qC\u001d\u0012\u0002\u0013\u0005!1\u001e\u0005\n\u00073I\u0014\u0011!C\u0005\u00077\u0011\u0011\u0003U1j[>t7\u000b]1sW^\u0013\u0018\u000e^3s\u0015\t\u0019E)\u0001\u0005d_6l\u0017M\u001c3t\u0015\t)e)A\u0003ta\u0006\u00148N\u0003\u0002H\u0011\u00061\u0001/Y5n_:T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011#\u0002\u0001O)jk\u0006CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&AB!osJ+g\r\u0005\u0002V16\taK\u0003\u0002X\t\u0006)qO]5uK&\u0011\u0011L\u0016\u0002\f/JLG/\u001a%fYB,'\u000f\u0005\u0002P7&\u0011A\f\u0015\u0002\b!J|G-^2u!\tye,\u0003\u0002`!\na1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\t!\r\u0005\u0002dK6\tAM\u0003\u0002a\r&\u0011a\r\u001a\u0002\u000f\r&dWm\u0015;pe\u0016$\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005\u0001rO]5uKJ{w\u000f\u0016:bG.LgnZ\u000b\u0002UB\u0011qj[\u0005\u0003YB\u0013qAQ8pY\u0016\fg.A\txe&$XMU8x)J\f7m[5oO\u0002\na\u0001P5oSRtDc\u00019sgB\u0011\u0011\u000fA\u0007\u0002\u0005\")\u0001-\u0002a\u0001E\"9\u0001.\u0002I\u0001\u0002\u0004Q\u0017a\u0003;bE2,7k\u00195f[\u0006,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u001a\u000baa]2iK6\f\u0017BA>y\u0005-!\u0016M\u00197f'\u000eDW-\\1\u0002\u0015\t,8m[3u\u001b>$W-F\u0001\u007f!\t\u0019w0C\u0002\u0002\u0002\u0011\u0014!BQ;dW\u0016$Xj\u001c3f\u0003)\u0019XM]5bY&TXM]\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b!\u0017\u0001B:j].LA!!\u0005\u0002\f\t92i\\7nSRlUm]:bO\u0016\u001cVM]5bY&TXM\u001d\u0015\u0004\u0011\u0005U\u0001cA(\u0002\u0018%\u0019\u0011\u0011\u0004)\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!C<sSR,G+\u001f9f+\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)CR\u0001\u0006if\u0004Xm]\u0005\u0005\u0003S\t\u0019CA\u0004S_^$\u0016\u0010]3\u0002\u0015]\u0014\u0018\u000e^3UsB,\u0007%\u0001\u0007xe&$XMQ;jY\u0012,'/\u0006\u0002\u00022A!\u0011\u0011BA\u001a\u0013\u0011\t)$a\u0003\u0003#\t\u000bGo\u00195Xe&$XMQ;jY\u0012,'/A\u0007xe&$XMQ;jY\u0012,'\u000fI\u0001\noJLG/Z(oYf$\u0012\u0001]\u0001\u0010o&$\bNU8x)J\f7m[5oOR!\u0011\u0011IA0!\u0019\t\u0019%a\u0015\u0002Z9!\u0011QIA(\u001d\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&\u0019\u00061AH]8pizJ\u0011!U\u0005\u0004\u0003#\u0002\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003+\n9FA\u0002TKFT1!!\u0015Q!\u0011\tI!a\u0017\n\t\u0005u\u00131\u0002\u0002\u000e\u0007>lW.\u001b;NKN\u001c\u0018mZ3\t\u000f\u0005\u0005t\u00021\u0001\u0002d\u0005!A-\u0019;b!\u0011\t)'a \u000f\t\u0005\u001d\u00141\u0010\b\u0005\u0003S\n)H\u0004\u0003\u0002l\u0005Md\u0002BA7\u0003crA!a\u0012\u0002p%\t1*\u0003\u0002J\u0015&\u0011Q\tS\u0005\u0005\u0003o\nI(A\u0002tc2T!!\u0012%\n\t\u0005E\u0013Q\u0010\u0006\u0005\u0003o\nI(\u0003\u0003\u0002\u0002\u0006\r%!\u0003#bi\u00064%/Y7f\u0015\u0011\t\t&! \u0002-A,'o]5ti\u0012+G.\u001a;j_:4Vm\u0019;peN$b!!\u0011\u0002\n\u0006m\u0005bBAF!\u0001\u0007\u0011QR\u0001\u0010I\u0016dW\r^5p]Z+7\r^8sgB1\u0011qRAI\u0003+k!!! \n\t\u0005M\u0015Q\u0010\u0002\b\t\u0006$\u0018m]3u!\r\t\u0018qS\u0005\u0004\u00033\u0013%aE*qCJ\\G)\u001a7fi&|gNV3di>\u0014\bbBAO!\u0001\u0007\u0011qT\u0001\tg:\f\u0007o\u001d5piB!\u0011\u0011UAR\u001b\u00051\u0015bAAS\r\nA1K\\1qg\"|G/\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003W\u000b\t\fE\u0002P\u0003[K1!a,Q\u0005\u0011)f.\u001b;\t\u000f\u0005M\u0016\u00031\u0001\u0002B\u0005q1m\\7nSRlUm]:bO\u0016\u001c\u0018\u0001\t2p_R\u001cHO]1q\u0003:$'+\u001a9beRLG/[8o\u0005f\\U-\u001f%bg\"$\"\"!/\u0002d\u0006\u0015\u0018q^Az!\u0019\tY,!1\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000bI(A\u0002sI\u0012LA!a1\u0002>\n\u0019!\u000b\u0012#\u0011\u000f=\u000b9-a3\u0002X&\u0019\u0011\u0011\u001a)\u0003\rQ+\b\u000f\\33!\u0011\ti-a5\u000e\u0005\u0005='bAAi\r\u0006q1M]8tgB\f'\u000f^5uS>t\u0017\u0002BAk\u0003\u001f\u0014AbS3z!\u0006\u0014Ho\u0014:S_^\u0004RaTAm\u0003;L1!a7Q\u0005\u0015\t%O]1z!\ry\u0015q\\\u0005\u0004\u0003C\u0004&\u0001\u0002\"zi\u0016Dq!!\u0019\u0013\u0001\u0004\t\u0019\u0007C\u0004\u0002hJ\u0001\r!!;\u0002\u0017A\f'/\u00197mK2L7/\u001c\t\u0004\u001f\u0006-\u0018bAAw!\n\u0019\u0011J\u001c;\t\u000f\u0005E(\u00031\u0001\u0002j\u0006i!o\\<LS:$7i\u001c7JIbDq!!>\u0013\u0001\u0004\ty\"A\u0004s_^$\u0016\u0010]3\u0002;I,\u0007/\u0019:uSRLwN\u001c\"z\u0017\u0016L\b+\u0019:uSRLwN\u001c%bg\"$\"\"a\u0019\u0002|\n\u0015!q\u0001B\u0005\u0011\u001d\tip\u0005a\u0001\u0003\u007f\fAb\u001d9be.\u001cVm]:j_:\u0004B!a$\u0003\u0002%!!1AA?\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\t\tg\u0005a\u0001\u0003GBq!a:\u0014\u0001\u0004\tI\u000fC\u0004\u0003\fM\u0001\r!!;\u0002\u00199,X.Q:tS\u001etWM]:\u0002AI,\u0007/\u0019:uSRLwN\u001c\"z!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c3Ck\u000e\\W\r\u001e\u000b\u0005\u0003G\u0012\t\u0002C\u0004\u0003\u0014Q\u0001\r!a\u0019\u0002\u0005\u00114\u0017!\u00049beRLG/[8o\u0007>d7\u000f\u0006\u0003\u0003\u001a\t\u0005\u0002CBA\"\u0003'\u0012Y\u0002\u0005\u0003\u0002\u0010\nu\u0011\u0002\u0002B\u0010\u0003{\u0012aaQ8mk6t\u0007b\u0002B\n+\u0001\u0007\u00111M\u0001\u0019I\u0016\u001cXM]5bY&TXmQ8n[&$X*Z:tC\u001e,GCBA-\u0005O\u0011I\u0003C\u0004\u0002\u0004Y\u0001\r!a\u0002\t\u000f\t-b\u00031\u0001\u0002X\u0006)!-\u001f;fg\nqQj\u001c3QCJ$\u0018\u000e^5p]\u0016\u00148#B\f\u00032ik\u0006\u0003\u0002B\u001a\u0005ki!!!\u001f\n\t\t]\u0012\u0011\u0010\u0002\f!\u0006\u0014H/\u001b;j_:,'/\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!!;\u0002\u0017A\f'\u000f^5uS>t7\u000f\t\u000b\u0005\u0005\u0003\u0012)\u0005E\u0002\u0003D]i\u0011\u0001\u0001\u0005\b\u0005sQ\u0002\u0019AAu\u00035qW/\u001c)beRLG/[8og\u0006aq-\u001a;QCJ$\u0018\u000e^5p]R!\u0011\u0011\u001eB'\u0011\u001d\u0011y\u0005\ba\u0001\u0005#\n1a[3z!\ry%1K\u0005\u0004\u0005+\u0002&aA!os\u0006!1m\u001c9z)\u0011\u0011\tEa\u0017\t\u0013\teR\u0004%AA\u0002\u0005%\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005CRC!!;\u0003d-\u0012!Q\r\t\u0005\u0005O\u0012\t(\u0004\u0002\u0003j)!!1\u000eB7\u0003%)hn\u00195fG.,GMC\u0002\u0003pA\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019H!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005s\u0002BAa\u001f\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)\u0001\u0003mC:<'B\u0001BB\u0003\u0011Q\u0017M^1\n\t\t\u001d%Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u000bBH\u0011%\u0011\t*IA\u0001\u0002\u0004\tI/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005/\u0003bA!'\u0003 \nESB\u0001BN\u0015\r\u0011i\nU\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BQ\u00057\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!Na*\t\u0013\tE5%!AA\u0002\tE\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\te\u0014AB3rk\u0006d7\u000fF\u0002k\u0005kC\u0011B!%'\u0003\u0003\u0005\rA!\u0015\u0002\u001d5{G\rU1si&$\u0018n\u001c8feB\u0019!1\t\u0015\u0014\t!\u0012i,\u0018\t\t\u0005\u007f\u0013)-!;\u0003B5\u0011!\u0011\u0019\u0006\u0004\u0005\u0007\u0004\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u000f\u0014\tMA\tBEN$(/Y2u\rVt7\r^5p]F\"\"A!/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\t\u0005#q\u001a\u0005\b\u0005sY\u0003\u0019AAu\u0003\u001d)h.\u00199qYf$BA!6\u0003\\B)qJa6\u0002j&\u0019!\u0011\u001c)\u0003\r=\u0003H/[8o\u0011%\u0011i\u000eLA\u0001\u0002\u0004\u0011\t%A\u0002yIA\"R\u0001\u001dBq\u0005GDq\u0001Y\u0017\u0011\u0002\u0003\u0007!\rC\u0004i[A\u0005\t\u0019\u00016\u0016\u0005\t\u001d(f\u00012\u0003d\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BwU\rQ'1\r\u000b\u0005\u0005#\u0012\t\u0010C\u0005\u0003\u0012J\n\t\u00111\u0001\u0002jR\u0019!N!>\t\u0013\tEE'!AA\u0002\tECc\u00016\u0003z\"I!\u0011S\u001c\u0002\u0002\u0003\u0007!\u0011K\u0001\u0012!\u0006LWn\u001c8Ta\u0006\u00148n\u0016:ji\u0016\u0014\bCA9:'\rId*\u0018\u000b\u0003\u0005{$2\u0001]B\u0003\u0011\u0015\u00017\b1\u0001c)\u0015\u00018\u0011BB\u0006\u0011\u0015\u0001G\b1\u0001c\u0011\u001dAG\b%AA\u0002)\fq\"\u00199qYf$C-\u001a4bk2$HE\r\u000b\u0005\u0007#\u0019)\u0002E\u0003P\u0005/\u001c\u0019\u0002E\u0003P\u0003\u000f\u0014'\u000e\u0003\u0005\u0003^z\n\t\u00111\u0001q\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019i\u0002\u0005\u0003\u0003|\r}\u0011\u0002BB\u0011\u0005{\u0012aa\u00142kK\u000e$\b")
public class PaimonSparkWriter
implements WriteHelper,
Product,
scala.Serializable {
    private TableSchema tableSchema;
    private BucketMode bucketMode;
    private transient CommitMessageSerializer serializer;
    private volatile PaimonSparkWriter$ModPartitioner$ ModPartitioner$module;
    private final FileStoreTable table;
    private final boolean writeRowTracking;
    private final RowType writeType;
    private final BatchWriteBuilder writeBuilder;
    private CoreOptions coreOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return PaimonSparkWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<FileStoreTable, Object>> unapply(PaimonSparkWriter paimonSparkWriter) {
        return PaimonSparkWriter$.MODULE$.unapply(paimonSparkWriter);
    }

    public static boolean apply$default$2() {
        return PaimonSparkWriter$.MODULE$.apply$default$2();
    }

    public static PaimonSparkWriter apply(FileStoreTable fileStoreTable, boolean bl) {
        return PaimonSparkWriter$.MODULE$.apply(fileStoreTable, bl);
    }

    public static PaimonSparkWriter apply(FileStoreTable fileStoreTable) {
        return PaimonSparkWriter$.MODULE$.apply(fileStoreTable);
    }

    @Override
    public void postCommit(Seq<CommitMessage> messages) {
        WriteHelper.postCommit$(this, messages);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private PaimonSparkWriter$ModPartitioner$ ModPartitioner() {
        if (this.ModPartitioner$module == null) {
            this.ModPartitioner$lzycompute$1();
        }
        return this.ModPartitioner$module;
    }

    private CoreOptions coreOptions$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.coreOptions = WriteHelper.coreOptions$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.coreOptions;
    }

    @Override
    public CoreOptions coreOptions() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.coreOptions$lzycompute();
        }
        return this.coreOptions;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public FileStoreTable table() {
        return this.table;
    }

    public boolean writeRowTracking() {
        return this.writeRowTracking;
    }

    private TableSchema tableSchema$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableSchema;
    }

    private TableSchema tableSchema() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.tableSchema$lzycompute();
        }
        return this.tableSchema;
    }

    private BucketMode bucketMode$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bucketMode = this.table().bucketMode();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.bucketMode;
    }

    private BucketMode bucketMode() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.bucketMode$lzycompute();
        }
        return this.bucketMode;
    }

    private CommitMessageSerializer serializer$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (!this.bitmap$trans$0) {
                this.serializer = new CommitMessageSerializer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.serializer;
    }

    private CommitMessageSerializer serializer() {
        if (!this.bitmap$trans$0) {
            return this.serializer$lzycompute();
        }
        return this.serializer;
    }

    private RowType writeType() {
        return this.writeType;
    }

    public BatchWriteBuilder writeBuilder() {
        return this.writeBuilder;
    }

    public PaimonSparkWriter writeOnly() {
        return PaimonSparkWriter$.MODULE$.apply((FileStoreTable)this.table().copy((Map)Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true")));
    }

    public PaimonSparkWriter withRowTracking() {
        if (this.coreOptions().rowTrackingEnabled()) {
            return new PaimonSparkWriter(this.table(), true);
        }
        return this;
    }

    public Seq<CommitMessage> write(Dataset<Row> data) {
        Dataset dataset;
        SparkSession sparkSession = data.sparkSession();
        BucketMode bucketMode = this.bucketMode();
        Dataset<Row> withInitBucketCol = ((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode) ? data : (((Object)((Object)BucketMode.KEY_DYNAMIC)).equals((Object)bucketMode) && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).contains((Object)SparkSystemColumns$.MODULE$.ROW_KIND_COL()) ? data.withColumn(SparkSystemColumns$.MODULE$.ROW_KIND_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)RowKind.INSERT.toByteValue()))).withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))) : data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))));
        int rowKindColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.ROW_KIND_COL());
        int bucketColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.BUCKET_COL());
        EncoderSerDeGroup encoderGroupWithBucketCol = new EncoderSerDeGroup(withInitBucketCol.schema());
        BucketMode bucketMode2 = this.bucketMode();
        if (((Object)((Object)BucketMode.KEY_DYNAMIC)).equals((Object)bucketMode2)) {
            RowType rowType = (RowType)SparkTypeUtils.toPaimonType((DataType)withInitBucketCol.schema());
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapped = this.bootstrapAndRepartitionByKeyHash(withInitBucketCol, assignerParallelism, rowKindColIdx, rowType);
            GlobalDynamicBucketProcessor globalDynamicBucketProcessor = new GlobalDynamicBucketProcessor(this.table(), rowType, Predef$.MODULE$.int2Integer(assignerParallelism), encoderGroupWithBucketCol);
            Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)sparkSession.createDataFrame(bootstrapped.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> globalDynamicBucketProcessor.processPartition((Iterator<Tuple2<KeyPartOrRow, byte[]>>)rowIterator), bootstrapped.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), withInitBucketCol.schema()));
            dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_DYNAMIC)).equals((Object)bucketMode2)) {
            int parallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            int assignerParallelism = !BoxesRunTime.equalsNumObject((Number)this.coreOptions().dynamicBucketMaxBuckets(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? Math.min(Predef$.MODULE$.Integer2int(this.coreOptions().dynamicBucketMaxBuckets()), parallelism) : parallelism;
            int numAssigners = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.coreOptions().dynamicBucketInitialBuckets()).map((Function1 & Serializable & scala.Serializable)initialBuckets -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$13(assignerParallelism, initialBuckets))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> assignerParallelism));
            dataset = this.table().snapshotManager().latestSnapshotFromFileSystem() == null ? this.writeWithBucketAssigner$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), (Function0 & Serializable & scala.Serializable)() -> {
                RowPartitionKeyExtractor extractor = new RowPartitionKeyExtractor(this.table().schema());
                SimpleHashBucketAssigner assigner = new SimpleHashBucketAssigner(numAssigners, TaskContext$.MODULE$.getPartitionId(), this.coreOptions().dynamicBucketTargetRowNum(), Predef$.MODULE$.Integer2int(this.coreOptions().dynamicBucketMaxBuckets()));
                return (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$16(this, assigner, extractor, row));
            }, sparkSession, rowKindColIdx) : this.writeWithBucketProcessor$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), new DynamicBucketProcessor(this.table(), bucketColIdx, assignerParallelism, numAssigners, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode2) ? true : ((Object)((Object)BucketMode.POSTPONE_MODE)).equals((Object)bucketMode2)) {
            Dataset<Row> input = data;
            if (this.tableSchema().partitionKeys().size() > 0) {
                CoreOptions.PartitionSinkStrategy partitionSinkStrategy = this.coreOptions().partitionSinkStrategy();
                if (((Object)((Object)CoreOptions.PartitionSinkStrategy.HASH)).equals((Object)partitionSinkStrategy)) {
                    input = data.repartition(this.partitionCols(data));
                }
            }
            java.util.List<String> clusteringColumns = this.coreOptions().clusteringColumns();
            if (!this.coreOptions().clusteringIncrementalEnabled() && !clusteringColumns.isEmpty()) {
                CoreOptions.OrderType strategy = this.coreOptions().clusteringStrategy(this.tableSchema().fields().size());
                TableSorter sorter = TableSorter.getSorter(this.table(), strategy, clusteringColumns);
                input = sorter.sort(data);
            }
            dataset = this.writeWithoutBucket$1((Dataset)input, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_FIXED)).equals((Object)bucketMode2)) {
            if (OptionUtils$.MODULE$.paimonExtensionEnabled() && BucketFunction$.MODULE$.supportsTable(this.table())) {
                int bucketNumber = this.coreOptions().bucket();
                Seq bucketKeyCol = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().bucketKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$17(this, x$3)), Buffer$.MODULE$.canBuildFrom())).map(arg_0 -> PaimonSparkWriter.$anonfun$write$18$adapted((Dataset)data, arg_0), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Seq args = (Seq)((TraversableLike)new .colon.colon((Object)functions$.MODULE$.lit((Object)new CoreOptions(this.tableSchema().options()).bucketFunctionType().toString()), (List)new .colon.colon((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)bucketNumber)), (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)bucketKeyCol, Seq$.MODULE$.canBuildFrom());
                Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.call_udf(BucketExpression$.MODULE$.FIXED_BUCKET(), args)));
                dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
            } else {
                dataset = this.writeWithBucketProcessor$1((Dataset)withInitBucketCol, new CommonBucketProcessor(this.table(), bucketColIdx, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
            }
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Spark doesn't support ").append((Object)this.bucketMode()).append(" mode.").toString());
        }
        Dataset written = dataset;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])written.collect())).map((Function1 & Serializable & scala.Serializable)x$4 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CommitMessage.class))))).toSeq();
    }

    public Seq<CommitMessage> persistDeletionVectors(Dataset<SparkDeletionVector> deletionVectors, Snapshot snapshot) {
        SparkSession sparkSession = deletionVectors.sparkSession();
        Dataset serializedCommits = deletionVectors.groupByKey((Function1 & Serializable & scala.Serializable)x$5 -> x$5.bucketPath(), sparkSession.implicits().newStringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(x$6, iter) -> {
            IndexFileHandler indexHandler = this.table().store().newIndexFileHandler();
            BaseAppendDeleteFileMaintainer dvIndexFileMaintainer = null;
            while (iter.hasNext()) {
                SparkDeletionVector sdv = (SparkDeletionVector)iter.next();
                if (dvIndexFileMaintainer == null) {
                    BinaryRow partition = SerializationUtils.deserializeBinaryRow(sdv.partition());
                    BucketMode bucketMode = this.bucketMode();
                    BucketMode bucketMode2 = BucketMode.BUCKET_UNAWARE;
                    BaseAppendDeleteFileMaintainer baseAppendDeleteFileMaintainer = !(bucketMode != null ? !((Object)((Object)bucketMode)).equals((Object)bucketMode2) : bucketMode2 != null) ? BaseAppendDeleteFileMaintainer.forUnawareAppend(indexHandler, snapshot, partition) : (dvIndexFileMaintainer = BaseAppendDeleteFileMaintainer.forBucketedAppend(indexHandler, snapshot, partition, sdv.bucket()));
                }
                if (dvIndexFileMaintainer == null) {
                    throw new RuntimeException("can't create the dv maintainer.");
                }
                dvIndexFileMaintainer.notifyNewDeletionVector(new Path(sdv.dataFilePath()).getName(), DeletionVector.deserializeFromBytes(sdv.deletionVector()));
            }
            java.util.List<IndexManifestEntry> indexEntries = dvIndexFileMaintainer.persist();
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexEntries).asScala()).partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$persistDeletionVectors$3(x$7)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer added = (Buffer)tuple2._1();
            Buffer deleted = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)added, (Object)deleted);
            Buffer added2 = (Buffer)tuple22._1();
            Buffer deleted2 = (Buffer)tuple22._2();
            CommitMessageImpl commitMessage = new CommitMessageImpl(dvIndexFileMaintainer.getPartition(), dvIndexFileMaintainer.getBucket(), null, new DataIncrement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)added2.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deleted2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava()), CompactIncrement.emptyIncrement());
            CommitMessageSerializer serializer = new CommitMessageSerializer();
            return serializer.serialize(commitMessage);
        }, sparkSession.implicits().newByteArrayEncoder());
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedCommits.collect())).map((Function1 & Serializable & scala.Serializable)x$11 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$11), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public void commit(Seq<CommitMessage> commitMessages) {
        try (BatchTableCommit tableCommit = this.writeBuilder().newCommit();){
            try {
                tableCommit.commit((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)commitMessages.toList()).asJava());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        this.postCommit(commitMessages);
    }

    private RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapAndRepartitionByKeyHash(Dataset<Row> data, int parallelism, int rowKindColIdx, RowType rowType) {
        int numSparkPartitions = data.rdd().getNumPartitions();
        java.util.List<String> primaryKeys = this.table().schema().primaryKeys();
        RowType bootstrapType = IndexBootstrap.bootstrapType(this.table().schema());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
            Projection keyPartProject = CodeGenUtils.newProjection(bootstrapType, primaryKeys);
            Projection rowProject = CodeGenUtils.newProjection(rowType, primaryKeys);
            InternalRowSerializer bootstrapSer = InternalSerializers.create(bootstrapType);
            InternalRowSerializer rowSer = InternalSerializers.create(rowType);
            CloseableIterator<InternalRow> bootstrapIterator = new IndexBootstrap(this.table()).bootstrap(numSparkPartitions, sparkPartitionId).toCloseableIterator();
            TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$12 -> {
                bootstrapIterator.close();
                return BoxedUnit.UNIT;
            });
            Function1<Row, SparkRow> toPaimonRow = SparkRowUtils$.MODULE$.toPaimonRow(rowType, rowKindColIdx);
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(bootstrapIterator).asScala()).map((Function1 & Serializable & scala.Serializable)row -> {
                byte[] bytes = SerializationUtils.serializeBinaryRow(bootstrapSer.toBinaryRow((InternalRow)row));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)keyPartProject.apply((InternalRow)row).hashCode()), (Object)new Tuple2((Object)KeyPartOrRow.KEY_PART, (Object)bytes));
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter.map((Function1 & Serializable & scala.Serializable)r -> {
                SparkRow sparkRow = (SparkRow)toPaimonRow.apply(r);
                byte[] bytes = SerializationUtils.serializeBinaryRow(rowSer.toBinaryRow(sparkRow));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)rowProject.apply(sparkRow).hashCode()), (Object)new Tuple2((Object)KeyPartOrRow.ROW, (Object)bytes));
            }));
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$13 -> (Tuple2)x$13._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Dataset<Row> repartitionByKeyPartitionHash(SparkSession sparkSession, Dataset<Row> data, int parallelism, int numAssigners) {
        return sparkSession.createDataFrame(RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            RowPartitionKeyExtractor rowPartitionKeyExtractor = new RowPartitionKeyExtractor(this.tableSchema());
            return iterator.map((Function1 & Serializable & scala.Serializable)row -> {
                SparkRow sparkRow = new SparkRow(this.writeType(), (Row)row);
                int partitionHash = rowPartitionKeyExtractor.partition(sparkRow).hashCode();
                int keyHash = rowPartitionKeyExtractor.trimmedPrimaryKey(sparkRow).hashCode();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BucketAssigner.computeHashKey(partitionHash, keyHash, parallelism, numAssigners)), row);
            });
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$14 -> (Row)x$14._2(), ClassTag$.MODULE$.apply(Row.class)), data.schema());
    }

    private Dataset<Row> repartitionByPartitionsAndBucket(Dataset<Row> df) {
        return df.repartition((Seq)this.partitionCols(df).$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.col(SparkSystemColumns$.MODULE$.BUCKET_COL()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
    }

    public Seq<Column> partitionCols(Dataset<Row> df) {
        StructType inputSchema = df.schema();
        return ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().partitionKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$partitionCols$1(this, x$15)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(inputSchema.fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    private CommitMessage deserializeCommitMessage(CommitMessageSerializer serializer, byte[] bytes) {
        CommitMessage commitMessage;
        try {
            commitMessage = serializer.deserialize(serializer.getVersion(), bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize CommitMessage's object", e);
        }
        return commitMessage;
    }

    public PaimonSparkWriter copy(FileStoreTable table, boolean writeRowTracking) {
        return new PaimonSparkWriter(table, writeRowTracking);
    }

    public FileStoreTable copy$default$1() {
        return this.table();
    }

    public boolean copy$default$2() {
        return this.writeRowTracking();
    }

    public String productPrefix() {
        return "PaimonSparkWriter";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.writeRowTracking());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PaimonSparkWriter;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.table()));
        n = Statics.mix((int)n, (int)(this.writeRowTracking() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PaimonSparkWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        PaimonSparkWriter paimonSparkWriter = (PaimonSparkWriter)x$1;
        FileStoreTable fileStoreTable = this.table();
        FileStoreTable fileStoreTable2 = paimonSparkWriter.table();
        if (fileStoreTable == null) {
            if (fileStoreTable2 != null) {
                return false;
            }
        } else if (!fileStoreTable.equals(fileStoreTable2)) return false;
        if (this.writeRowTracking() != paimonSparkWriter.writeRowTracking()) return false;
        if (!paimonSparkWriter.canEqual(this)) return false;
        return true;
    }

    private final void ModPartitioner$lzycompute$1() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (this.ModPartitioner$module == null) {
                this.ModPartitioner$module = new PaimonSparkWriter$ModPartitioner$(this);
            }
        }
    }

    private final SparkTableWrite newWrite$1(int rowKindColIdx$1) {
        return new SparkTableWrite(this.writeBuilder(), this.writeType(), rowKindColIdx$1, this.writeRowTracking());
    }

    private static final int sparkParallelism$1(SparkSession sparkSession$1) {
        int defaultParallelism = sparkSession$1.sparkContext().defaultParallelism();
        int numShufflePartitions = sparkSession$1.sessionState().conf().numShufflePartitions();
        return Math.max(defaultParallelism, numShufflePartitions);
    }

    private final Dataset writeWithoutBucket$1(Dataset dataFrame, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row);
                    return BoxedUnit.UNIT;
                });
                iterator = write.finish();
            }
            return iterator;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucket$1(Dataset dataFrame, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, row.getInt(bucketColIdx$1));
                    return BoxedUnit.UNIT;
                });
                iterator = write.finish();
            }
            return iterator;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucketProcessor$1(Dataset dataFrame, BucketProcessor processor, EncoderSerDeGroup encoderGroupWithBucketCol$1, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> processor.processPartition(rowIterator), encoderGroupWithBucketCol$1.encoder()).toDF());
        return this.writeWithBucket$1(repartitioned, bucketColIdx$1, sparkSession$1, rowKindColIdx$1);
    }

    private final Dataset writeWithBucketAssigner$1(Dataset dataFrame, Function0 funcFactory, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator;
            Function1 assigner = (Function1)funcFactory.apply();
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, BoxesRunTime.unboxToInt((Object)assigner.apply((Object)row)));
                    return BoxedUnit.UNIT;
                });
                iterator = write.finish();
            }
            return iterator;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    public static final /* synthetic */ int $anonfun$write$13(int assignerParallelism$1, Integer initialBuckets) {
        return Math.min(Predef$.MODULE$.Integer2int(initialBuckets), assignerParallelism$1);
    }

    private final Dataset partitionByKey$1(SparkSession sparkSession$1, Dataset withInitBucketCol$1, int assignerParallelism$1, int numAssigners$1) {
        return this.repartitionByKeyPartitionHash(sparkSession$1, (Dataset<Row>)withInitBucketCol$1, assignerParallelism$1, numAssigners$1);
    }

    public static final /* synthetic */ int $anonfun$write$16(PaimonSparkWriter $this, SimpleHashBucketAssigner assigner$2, RowPartitionKeyExtractor extractor$1, Row row) {
        SparkRow sparkRow = new SparkRow($this.writeType(), row);
        return assigner$2.assign(extractor$1.partition(sparkRow), extractor$1.trimmedPrimaryKey(sparkRow).hashCode());
    }

    public static final /* synthetic */ int $anonfun$write$17(PaimonSparkWriter $this, String x$3) {
        return $this.tableSchema().fieldNames().indexOf(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$persistDeletionVectors$3(IndexManifestEntry x$7) {
        FileKind fileKind = x$7.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public static final /* synthetic */ int $anonfun$partitionCols$1(PaimonSparkWriter $this, String x$15) {
        return $this.tableSchema().fieldNames().indexOf(x$15);
    }

    public PaimonSparkWriter(FileStoreTable table, boolean writeRowTracking) {
        this.table = table;
        this.writeRowTracking = writeRowTracking;
        Logging.$init$((Logging)this);
        WriteHelper.$init$(this);
        Product.$init$((Product)this);
        this.writeType = writeRowTracking ? SpecialFields.rowTypeWithRowTracking(table.rowType(), true) : table.rowType();
        this.writeBuilder = table.newBatchWriteBuilder();
    }

    public static final /* synthetic */ Column $anonfun$write$18$adapted(Dataset data$1, Object x) {
        return functions$.MODULE$.col(data$1.schema().fieldNames()[BoxesRunTime.unboxToInt((Object)x)]);
    }

    private class ModPartitioner
    extends Partitioner
    implements Product {
        private final int partitions;
        public final /* synthetic */ PaimonSparkWriter $outer;

        public int partitions() {
            return this.partitions;
        }

        public int numPartitions() {
            return this.partitions();
        }

        public int getPartition(Object key) {
            return Math.abs(BoxesRunTime.unboxToInt((Object)key) % this.numPartitions());
        }

        public ModPartitioner copy(int partitions) {
            return new ModPartitioner(this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer(), partitions);
        }

        public int copy$default$1() {
            return this.partitions();
        }

        public String productPrefix() {
            return "ModPartitioner";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.partitions());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ModPartitioner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partitions());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ModPartitioner)) return false;
            if (((ModPartitioner)((Object)object)).org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() != this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ModPartitioner modPartitioner = (ModPartitioner)((Object)x$1);
            if (this.partitions() != modPartitioner.partitions()) return false;
            if (!modPartitioner.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ PaimonSparkWriter org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() {
            return this.$outer;
        }

        public ModPartitioner(PaimonSparkWriter $outer, int partitions) {
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

