/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.TableMigrationUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateDatabaseProcedure
extends BaseProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateDatabaseProcedure.class);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("source_type", DataTypes.StringType), ProcedureParameter.required("database", DataTypes.StringType), ProcedureParameter.optional("options", DataTypes.StringType), ProcedureParameter.optional("options_map", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType)), ProcedureParameter.optional("parallelism", DataTypes.IntegerType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata.empty())});

    protected MigrateDatabaseProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String format = args.getString(0);
        String database = args.getString(1);
        String properties = args.isNullAt(2) ? null : args.getString(2);
        MapData mapData = args.isNullAt(3) ? null : args.getMap(3);
        Map<String, String> optionMap = MigrateDatabaseProcedure.mapDataToHashMap(mapData);
        int parallelism = args.isNullAt(4) ? Runtime.getRuntime().availableProcessors() : args.getInt(4);
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        Map<String, String> options = ParameterUtils.parseCommaSeparatedKeyValues(properties);
        options.putAll(optionMap);
        List<Migrator> migrators = TableMigrationUtils.getImporters(format, paimonCatalog, database, parallelism, options);
        int errorCount = 0;
        int successCount = 0;
        for (Migrator migrator : migrators) {
            try {
                migrator.executeMigrate();
                migrator.renameTable(false);
                ++successCount;
            }
            catch (Exception e) {
                ++errorCount;
                LOG.error("Call migrate_database error:{}", (Object)e.getMessage());
            }
        }
        String retStr = String.format("migrate database is finished, success cnt: %s , failed cnt: %s", successCount, errorCount);
        return new InternalRow[]{this.newInternalRow(UTF8String.fromString((String)retStr))};
    }

    public static Map<String, String> mapDataToHashMap(MapData mapData) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapData != null) {
            for (int index = 0; index < mapData.numElements(); ++index) {
                map.put(mapData.keyArray().getUTF8String(index).toString(), mapData.valueArray().getUTF8String(index).toString());
            }
        }
        return map;
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<MigrateDatabaseProcedure>(){

            @Override
            public MigrateDatabaseProcedure doBuild() {
                return new MigrateDatabaseProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "MigrateDatabaseProcedure";
    }
}

