/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class RollbackProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("version", DataTypes.StringType), ProcedureParameter.optional("snapshot", DataTypes.LongType), ProcedureParameter.optional("tag", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("previous_snapshot_id", DataTypes.LongType, false, Metadata.empty()), new StructField("current_snapshot_id", DataTypes.LongType, false, Metadata.empty())});

    private RollbackProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String version = args.isNullAt(1) ? null : args.getString(1);
        return this.modifyPaimonTable(tableIdent, table -> {
            long currentSnapshotId;
            Long snapshot = null;
            String tag = null;
            if (!StringUtils.isNullOrWhitespaceOnly(version)) {
                Preconditions.checkState(args.isNullAt(2) && args.isNullAt(3), "only can set one of version/snapshot/tag in RollbackProcedure.");
                if (version.chars().allMatch(Character::isDigit)) {
                    snapshot = Long.parseLong(version);
                } else {
                    tag = version;
                }
            } else {
                Preconditions.checkState(args.isNullAt(2) && !args.isNullAt(3) || !args.isNullAt(2) && args.isNullAt(3), "only can set one of version/snapshot/tag in RollbackProcedure.");
                snapshot = args.isNullAt(2) ? null : Long.valueOf(args.getLong(2));
                tag = args.isNullAt(3) ? null : args.getString(3);
            }
            FileStore<?> store = ((FileStoreTable)table).store();
            Snapshot latestSnapshot = store.snapshotManager().latestSnapshot();
            Preconditions.checkNotNull(latestSnapshot, "Latest snapshot is null, can not rollback.");
            if (snapshot != null) {
                table.rollbackTo(snapshot);
                currentSnapshotId = snapshot;
            } else {
                table.rollbackTo(tag);
                currentSnapshotId = store.newTagManager().getOrThrow(tag).trimToSnapshot().id();
            }
            InternalRow outputRow = this.newInternalRow(latestSnapshot.id(), currentSnapshotId);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RollbackProcedure>(){

            @Override
            public RollbackProcedure doBuild() {
                return new RollbackProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RollbackProcedure";
    }
}

