/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.spark.SparkCatalogOptions;
import org.apache.paimon.spark.SparkConnectorOptions;
import org.apache.paimon.table.Table;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class OptionUtils$
implements SQLConfHelper {
    public static OptionUtils$ MODULE$;
    private final String PAIMON_OPTION_PREFIX;
    private final String SPARK_CATALOG_PREFIX;

    static {
        new OptionUtils$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    private String PAIMON_OPTION_PREFIX() {
        return this.PAIMON_OPTION_PREFIX;
    }

    private String SPARK_CATALOG_PREFIX() {
        return this.SPARK_CATALOG_PREFIX;
    }

    public boolean paimonExtensionEnabled() {
        return ((SeqLike)this.conf().getConf(StaticSQLConf$.MODULE$.SPARK_SESSION_EXTENSIONS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).contains((Object)"org.apache.paimon.spark.extensions.PaimonSparkSessionExtensions");
    }

    public String getOptionString(ConfigOption<?> option) {
        return this.conf().getConfString(new StringBuilder(0).append(this.PAIMON_OPTION_PREFIX()).append(option.key()).toString(), option.defaultValue().toString());
    }

    private String getSparkVersionSpecificDefault(ConfigOption<?> option) {
        String string;
        String sparkVersion = package$.MODULE$.SPARK_VERSION();
        String string2 = string = option.key();
        String string3 = SparkConnectorOptions.USE_V2_WRITE.key();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (new StringOps(Predef$.MODULE$.augmentString(sparkVersion)).$greater$eq((Object)"3.4")) {
                return "false";
            }
            return option.defaultValue().toString();
        }
        return option.defaultValue().toString();
    }

    public void checkRequiredConfigurations() {
        if (new StringOps(Predef$.MODULE$.augmentString(this.getOptionString(SparkConnectorOptions.REQUIRED_SPARK_CONFS_CHECK_ENABLED))).toBoolean()) {
            if (!this.paimonExtensionEnabled()) {
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("\n            |When using Paimon, it is necessary to configure `spark.sql.extensions` and ensure that it includes `org.apache.paimon.spark.extensions.PaimonSparkSessionExtensions`.\n            |You can disable this check by configuring `spark.paimon.requiredSparkConfsCheck.enabled` to `false`, but it is strongly discouraged to do so.\n            |")).stripMargin());
            }
            return;
        }
    }

    public boolean useV2Write() {
        String defaultValue = this.getSparkVersionSpecificDefault(SparkConnectorOptions.USE_V2_WRITE);
        return new StringOps(Predef$.MODULE$.augmentString(this.conf().getConfString(new StringBuilder(0).append(this.PAIMON_OPTION_PREFIX()).append(SparkConnectorOptions.USE_V2_WRITE.key()).toString(), defaultValue))).toBoolean();
    }

    public boolean writeMergeSchemaEnabled() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getOptionString(SparkConnectorOptions.MERGE_SCHEMA))).toBoolean();
    }

    public boolean writeMergeSchemaExplicitCastEnabled() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getOptionString(SparkConnectorOptions.EXPLICIT_CAST))).toBoolean();
    }

    public boolean v1FunctionEnabled() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getOptionString(SparkCatalogOptions.V1FUNCTION_ENABLED))).toBoolean();
    }

    private java.util.Map<String, String> mergeSQLConf(java.util.Map<String, String> extraOptions) {
        HashMap<String, String> mergedOptions = new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)this.conf().getAllConfs().filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(OptionUtils$.MODULE$.PAIMON_OPTION_PREFIX()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(key)).stripPrefix(MODULE$.PAIMON_OPTION_PREFIX())), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
        mergedOptions.putAll(extraOptions);
        return mergedOptions;
    }

    private java.util.Map<String, String> mergeSQLConfWithIdentifier(java.util.Map<String, String> extraOptions, String catalogName, Identifier ident) {
        String tableOptionsTemplate = String.format("(%s)(%s|\\*)\\.(%s|\\*)\\.(%s|\\*)\\.(.+)", this.PAIMON_OPTION_PREFIX(), catalogName, ident.getDatabaseName(), ident.getObjectName());
        Pattern tableOptionsPattern = Pattern.compile(tableOptionsTemplate);
        java.util.Map<String, String> mergedOptions = OptionsUtils.convertToDynamicTableProperties((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.conf().getAllConfs()).asJava(), this.PAIMON_OPTION_PREFIX(), tableOptionsPattern, 5);
        mergedOptions.putAll(extraOptions);
        return mergedOptions;
    }

    public <T extends Table> T copyWithSQLConf(T table, String catalogName, Identifier ident, java.util.Map<String, String> extraOptions) {
        java.util.Map<String, String> mergedOptions;
        java.util.Map<String, String> map = mergedOptions = catalogName != null && ident != null ? this.mergeSQLConfWithIdentifier(extraOptions, catalogName, ident) : this.mergeSQLConf(extraOptions);
        if (mergedOptions.isEmpty()) {
            return table;
        }
        return (T)table.copy(mergedOptions);
    }

    public <T extends Table> String copyWithSQLConf$default$2() {
        return null;
    }

    public <T extends Table> Identifier copyWithSQLConf$default$3() {
        return null;
    }

    public <T extends Table> java.util.Map<String, String> copyWithSQLConf$default$4() {
        return new HashMap<String, String>();
    }

    private OptionUtils$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        this.PAIMON_OPTION_PREFIX = "spark.paimon.";
        this.SPARK_CATALOG_PREFIX = "spark.sql.catalog.";
    }
}

