/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.format;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileRecordReader;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.format.FormatDataSplit;
import org.apache.paimon.table.format.FormatTableRead;
import org.apache.paimon.table.format.FormatTableScan;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Pair;

public class FormatReadBuilder
implements ReadBuilder {
    private static final long serialVersionUID = 1L;
    private final FormatTable table;
    private RowType readType;
    private final CoreOptions options;
    @Nullable
    private Predicate filter;
    @Nullable
    private PartitionPredicate partitionFilter;
    @Nullable
    private Integer limit;

    public FormatReadBuilder(FormatTable table) {
        this.table = table;
        this.readType = this.table.rowType();
        this.options = new CoreOptions(table.options());
    }

    @Override
    public String tableName() {
        return this.table.name();
    }

    @Override
    public RowType readType() {
        return this.readType;
    }

    @Override
    public ReadBuilder withFilter(Predicate predicate) {
        this.filter = this.filter == null ? predicate : PredicateBuilder.and(this.filter, predicate);
        return this;
    }

    @Override
    public ReadBuilder withPartitionFilter(Map<String, String> partitionSpec) {
        if (partitionSpec != null) {
            RowType partitionType = this.table.rowType().project(this.table.partitionKeys());
            PartitionPredicate partitionPredicate = PartitionPredicate.fromPredicate(partitionType, PartitionPredicate.createPartitionPredicate(partitionSpec, partitionType, this.table.defaultPartName()));
            this.withPartitionFilter(partitionPredicate);
        }
        return this;
    }

    @Override
    public ReadBuilder withPartitionFilter(PartitionPredicate partitionPredicate) {
        this.partitionFilter = partitionPredicate;
        return this;
    }

    @Override
    public ReadBuilder withReadType(RowType readType) {
        this.readType = readType;
        return this;
    }

    @Override
    public ReadBuilder withProjection(int[] projection) {
        if (projection == null) {
            return this;
        }
        return this.withReadType(this.readType().project(projection));
    }

    @Override
    public ReadBuilder withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public TableScan newScan() {
        int[] fieldIdxToPartitionIdx;
        Pair<List<Predicate>, List<Predicate>> partitionAndNonPartitionFilter;
        List<Predicate> partitionFilters;
        PartitionPredicate partitionFilter = this.partitionFilter;
        if (partitionFilter == null && this.filter != null && !this.table.partitionKeys().isEmpty() && !(partitionFilters = (partitionAndNonPartitionFilter = PredicateBuilder.splitAndByPartition(this.filter, fieldIdxToPartitionIdx = PredicateBuilder.fieldIdxToPartitionIdx(this.table.rowType(), this.table.partitionKeys()))).getLeft()).isEmpty()) {
            RowType partitionType = this.table.rowType().project(this.table.partitionKeys());
            partitionFilter = PartitionPredicate.fromPredicate(partitionType, PredicateBuilder.and(partitionFilters));
        }
        return new FormatTableScan(this.table, partitionFilter, this.limit);
    }

    @Override
    public TableRead newRead() {
        return new FormatTableRead(this.readType(), this, this.filter, this.limit);
    }

    protected RecordReader<InternalRow> createReader(FormatDataSplit dataSplit) throws IOException {
        Path filePath = dataSplit.dataPath();
        FormatReaderContext formatReaderContext = new FormatReaderContext(this.table.fileIO(), filePath, dataSplit.length(), null);
        FormatReaderFactory readerFactory = FileFormatDiscover.of(this.options).discover(this.options.formatType()).createReaderFactory(this.table.rowType(), this.readType(), PredicateBuilder.splitAnd(this.filter));
        Pair<int[], RowType> partitionMapping = PartitionUtils.getPartitionMapping(this.table.partitionKeys(), this.readType().getFields(), this.table.partitionType());
        return new DataFileRecordReader(this.readType(), readerFactory, formatReaderContext, null, null, PartitionUtils.create(partitionMapping, dataSplit.partition()), false, null, 0L, Collections.emptyMap());
    }

    @Override
    public ReadBuilder withTopN(TopN topN) {
        return this;
    }

    @Override
    public ReadBuilder dropStats() {
        return this;
    }

    @Override
    public ReadBuilder withBucketFilter(Filter<Integer> bucketFilter) {
        throw new UnsupportedOperationException("Format Table does not support withBucketFilter.");
    }

    @Override
    public ReadBuilder withBucket(int bucket) {
        throw new UnsupportedOperationException("Format Table does not support withBucket.");
    }

    @Override
    public ReadBuilder withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
        throw new UnsupportedOperationException("Format Table does not support withShard.");
    }

    @Override
    public StreamTableScan newStreamScan() {
        throw new UnsupportedOperationException("Format Table does not support stream scan.");
    }
}

