/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;

public class ResolvingFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    private final Map<CacheKey, FileIO> fileIOMap = new ConcurrentHashMap<CacheKey, FileIO>();
    private CatalogContext context;

    @Override
    public boolean isObjectStore() {
        String warehouse = this.context.options().get(CatalogOptions.WAREHOUSE);
        if (warehouse == null) {
            return false;
        }
        Path path = new Path(warehouse);
        String scheme = path.toUri().getScheme();
        return scheme != null && !scheme.equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("hdfs");
    }

    @Override
    public void configure(CatalogContext context) {
        Options options = new Options();
        context.options().toMap().forEach(options::set);
        options.set(CatalogOptions.RESOLVING_FILE_IO_ENABLED, false);
        this.context = CatalogContext.create(options, context.hadoopConf(), context.preferIO(), context.fallbackIO());
    }

    @Override
    public SeekableInputStream newInputStream(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).newInputStream(path));
    }

    @Override
    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        return this.wrap(() -> this.fileIO(path).newOutputStream(path, overwrite));
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).getFileStatus(path));
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).listStatus(path));
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).exists(path));
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.wrap(() -> this.fileIO(path).delete(path, recursive));
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.wrap(() -> this.fileIO(path).mkdirs(path));
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.wrap(() -> this.fileIO(src).rename(src, dst));
    }

    @VisibleForTesting
    public FileIO fileIO(Path path) throws IOException {
        CacheKey cacheKey = new CacheKey(path.toUri().getScheme(), path.toUri().getAuthority());
        return this.fileIOMap.computeIfAbsent(cacheKey, k -> {
            try {
                return FileIO.get(path, this.context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T wrap(Func<T> func) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ResolvingFileIO.class.getClassLoader());
            T t = func.apply();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static class CacheKey
    implements Serializable {
        private final String scheme;
        private final String authority;

        private CacheKey(String scheme, String authority) {
            this.scheme = scheme;
            this.authority = authority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.scheme, cacheKey.scheme) && Objects.equals(this.authority, cacheKey.authority);
        }

        public int hashCode() {
            return Objects.hash(this.scheme, this.authority);
        }
    }

    @FunctionalInterface
    protected static interface Func<T> {
        public T apply() throws IOException;
    }
}

