/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.spark.JavaLambdaStringToMethodConverter;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.DataType;

public class PaimonSparkScalarFunction
implements ScalarFunction<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String functionName;
    private final List<DataType> inputTypes;
    private final DataType resultType;
    private String javaType;
    private String lambdaExpression;
    private transient Method compiledMethod;

    public PaimonSparkScalarFunction(String functionName, List<DataType> inputTypes, DataType resultType, String javaType, String lambdaExpression) {
        this.functionName = functionName;
        this.inputTypes = inputTypes;
        this.resultType = resultType;
        this.javaType = javaType;
        this.lambdaExpression = lambdaExpression;
    }

    public DataType[] inputTypes() {
        return this.inputTypes.toArray(new DataType[this.inputTypes.size()]);
    }

    public DataType resultType() {
        return this.resultType;
    }

    public Object produceResult(InternalRow input) {
        try {
            if (this.compiledMethod == null) {
                this.compiledMethod = JavaLambdaStringToMethodConverter.compileAndLoadMethod(this.functionName, this.lambdaExpression, this.javaType);
            }
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (int i = 0; i < this.inputTypes().length; ++i) {
                Object obj = CatalogUtils.convertSparkJavaToPaimonJava(this.inputTypes()[i], input.get(i, this.inputTypes()[i]));
                parameters.add(obj);
            }
            return this.compiledMethod.invoke(null, parameters.toArray(new Object[parameters.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String name() {
        return this.functionName;
    }

    public String canonicalName() {
        return this.functionName;
    }
}

