/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkUtils;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.types.RowType;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.PaimonUtils$;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\b\u0011\u0001eA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0004D\u0001\t\u0007I\u0011\u0001#\t\r-\u0003\u0001\u0015!\u0003F\u0011\u001da\u0005A1A\u0005\u00025Ca!\u0015\u0001!\u0002\u0013q\u0005\"\u0002'\u0001\t\u0003\u0011\u0006\"\u0002'\u0001\t\u0003y\u0006\"B2\u0001\t\u0003!\u0007\"B<\u0001\t\u0003B\b\"B=\u0001\t\u0013Q\bBB@\u0001\t\u0013\t\tAA\bTa\u0006\u00148\u000eV1cY\u0016<&/\u001b;f\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0001/Y5n_:T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001bEA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001cG%\u0011A\u0005\b\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\u0019]\u0014\u0018\u000e^3Ck&dG-\u001a:\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001B:j].T!a\u000b\n\u0002\u000bQ\f'\r\\3\n\u00055B#!\u0005\"bi\u000eDwK]5uK\n+\u0018\u000e\u001c3fe\u00069!o\\<UsB,\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0013\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0014GA\u0004S_^$\u0016\u0010]3\u0002\u001bI|woS5oI\u000e{G.\u00133y!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\ty\u0002\u0015I\u0011\t\u0003\u007f\u0001i\u0011\u0001\u0005\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006]\u0011\u0001\ra\f\u0005\u0006k\u0011\u0001\rAN\u0001\nS>l\u0015M\\1hKJ,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011J\tA\u0001Z5tW&\u0011!j\u0012\u0002\n\u0013>k\u0015M\\1hKJ\f!\"[8NC:\fw-\u001a:!\u0003\u00159(/\u001b;f+\u0005q\u0005CA\u0014P\u0013\t\u0001\u0006FA\bCCR\u001c\u0007\u000eV1cY\u0016<&/\u001b;f\u0003\u00199(/\u001b;fAQ\u00111K\u0016\t\u0003oQK!!\u0016\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006/&\u0001\r\u0001W\u0001\u0004e><\bCA-^\u001b\u0005Q&BA.]\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#QI!A\u0018.\u0003\u0007I{w\u000fF\u0002TA\u0006DQa\u0016\u0006A\u0002aCQA\u0019\u0006A\u0002Y\naAY;dW\u0016$\u0018A\u00024j]&\u001c\b\u000eF\u0001f!\r1g.\u001d\b\u0003O2t!\u0001[6\u000e\u0003%T!A\u001b\r\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014BA79\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\u0011%#XM]1u_JT!!\u001c\u001d\u0011\u0007]\u0012H/\u0003\u0002tq\t)\u0011I\u001d:bsB\u0011q'^\u0005\u0003mb\u0012AAQ=uK\u0006)1\r\\8tKR\t1+A\u0006u_B\u000b\u0017.\\8o%><HCA>\u007f!\tyD0\u0003\u0002~!\tA1\u000b]1sWJ{w\u000fC\u0003X\u001b\u0001\u0007\u0001,A\nsKB|'\u000f^(viB,H/T3ue&\u001c7\u000fF\u0003T\u0003\u0007\ti\u0001C\u0004\u0002\u00069\u0001\r!a\u0002\u0002\u0019\tLH/Z:Xe&$H/\u001a8\u0011\u0007]\nI!C\u0002\u0002\fa\u0012A\u0001T8oO\"9\u0011q\u0002\bA\u0002\u0005\u001d\u0011A\u0004:fG>\u0014Hm],sSR$XM\u001c")
public class SparkTableWrite
implements AutoCloseable {
    private final RowType rowType;
    private final int rowKindColIdx;
    private final IOManager ioManager;
    private final BatchTableWrite write;

    public IOManager ioManager() {
        return this.ioManager;
    }

    public BatchTableWrite write() {
        return this.write;
    }

    public void write(Row row) {
        this.write().write(this.toPaimonRow(row));
    }

    public void write(Row row, int bucket) {
        this.write().write(this.toPaimonRow(row), bucket);
    }

    public Iterator<byte[]> finish() {
        LongRef bytesWritten = LongRef.create((long)0L);
        LongRef recordsWritten = LongRef.create((long)0L);
        ListBuffer commitMessages = new ListBuffer();
        CommitMessageSerializer serializer = new CommitMessageSerializer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.write().prepareCommit()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CommitMessage commitMessage = x0$1;
            if (commitMessage instanceof CommitMessageImpl) {
                CommitMessageImpl commitMessageImpl = (CommitMessageImpl)commitMessage;
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(commitMessageImpl.newFilesIncrement().newFiles()).asScala()).foreach((Function1 & Serializable & scala.Serializable)dataFileMeta -> {
                    SparkTableWrite.$anonfun$finish$2(bytesWritten, recordsWritten, dataFileMeta);
                    return BoxedUnit.UNIT;
                });
                return commitMessages.$plus$eq((Object)serializer.serialize(commitMessageImpl));
            }
            throw new MatchError((Object)commitMessage);
        });
        this.reportOutputMetrics(bytesWritten.elem, recordsWritten.elem);
        return commitMessages.iterator();
    }

    @Override
    public void close() {
        this.write().close();
        this.ioManager().close();
    }

    private SparkRow toPaimonRow(Row row) {
        return new SparkRow(this.rowType, row, SparkRowUtils$.MODULE$.getRowKind(row, this.rowKindColIdx));
    }

    private void reportOutputMetrics(long bytesWritten, long recordsWritten) {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        if (taskContext != null) {
            PaimonUtils$.MODULE$.updateOutputMetrics(taskContext.taskMetrics().outputMetrics(), bytesWritten, recordsWritten);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$finish$2(LongRef bytesWritten$1, LongRef recordsWritten$1, DataFileMeta dataFileMeta) {
        bytesWritten$1.elem += dataFileMeta.fileSize();
        recordsWritten$1.elem += dataFileMeta.rowCount();
    }

    public SparkTableWrite(BatchWriteBuilder writeBuilder, RowType rowType, int rowKindColIdx) {
        this.rowType = rowType;
        this.rowKindColIdx = rowKindColIdx;
        this.ioManager = SparkUtils.createIOManager();
        this.write = (BatchTableWrite)writeBuilder.newWrite().withIOManager(this.ioManager());
    }
}

