/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.LookupStoreWriter;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.BloomFilter;

public interface LookupStoreFactory {
    public LookupStoreWriter createWriter(File var1, @Nullable BloomFilter.Builder var2) throws IOException;

    public LookupStoreReader createReader(File var1) throws IOException;

    public static Function<Long, BloomFilter.Builder> bfGenerator(Options options) {
        Function<Long, BloomFilter.Builder> bfGenerator = rowCount -> null;
        if (options.get(CoreOptions.LOOKUP_CACHE_BLOOM_FILTER_ENABLED).booleanValue()) {
            double bfFpp = options.get(CoreOptions.LOOKUP_CACHE_BLOOM_FILTER_FPP);
            bfGenerator = rowCount -> {
                if (rowCount > 0L) {
                    return BloomFilter.builder(rowCount, bfFpp);
                }
                return null;
            };
        }
        return bfGenerator;
    }
}

