/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataOutputSerializer;
import org.apache.paimon.lookup.BulkLoader;
import org.apache.paimon.lookup.RocksDBStateFactory;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.MoreExecutors;
import org.apache.paimon.sort.BinaryExternalSortBuffer;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteOptions;

public abstract class RocksDBState<K, V, CacheV> {
    protected final RocksDBStateFactory stateFactory;
    protected final RocksDB db;
    protected final WriteOptions writeOptions;
    protected final ColumnFamilyHandle columnFamily;
    protected final Serializer<K> keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final DataOutputSerializer keyOutView;
    protected final DataInputDeserializer valueInputView;
    protected final DataOutputSerializer valueOutputView;
    protected final Cache<ByteArray, CacheV> cache;

    public RocksDBState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        this.stateFactory = stateFactory;
        this.db = stateFactory.db();
        this.columnFamily = columnFamily;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyOutView = new DataOutputSerializer(32);
        this.valueInputView = new DataInputDeserializer();
        this.valueOutputView = new DataOutputSerializer(32);
        this.writeOptions = new WriteOptions().setDisableWAL(true);
        this.cache = Caffeine.newBuilder().maximumSize(lruCacheSize).executor(MoreExecutors.directExecutor()).build();
    }

    public byte[] serializeKey(K key) throws IOException {
        this.keyOutView.clear();
        this.keySerializer.serialize(key, this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    protected ByteArray wrap(byte[] bytes) {
        return new ByteArray(bytes);
    }

    protected Reference ref(byte[] bytes) {
        return new Reference(bytes);
    }

    public BulkLoader createBulkLoader() {
        return new BulkLoader(this.db, this.stateFactory.options(), this.columnFamily, this.stateFactory.path());
    }

    public static BinaryExternalSortBuffer createBulkLoadSorter(IOManager ioManager, CoreOptions options) {
        return BinaryExternalSortBuffer.create(ioManager, RowType.of(DataTypes.BYTES()), RowType.of(DataTypes.BYTES(), DataTypes.BYTES()), options.writeBufferSize() / 2L, options.pageSize(), options.localSortMaxNumFileHandles());
    }

    protected static class Reference {
        @Nullable
        protected final byte[] bytes;

        protected Reference(@Nullable byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean isPresent() {
            return this.bytes != null;
        }
    }

    protected static class ByteArray {
        protected final byte[] bytes;

        protected ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArray byteArray = (ByteArray)o;
            return Arrays.equals(this.bytes, byteArray.bytes);
        }
    }
}

