/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.RowCompactedSerializer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataOutputSerializer;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.LookupStoreWriter;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.LookupUtils;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.MoreExecutors;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BloomFilter;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.IOFunction;
import org.apache.paimon.utils.Preconditions;

public class LookupLevels
implements Levels.DropFileCallback,
Closeable {
    private final Levels levels;
    private final Comparator<InternalRow> keyComparator;
    private final RowCompactedSerializer keySerializer;
    private final RowCompactedSerializer valueSerializer;
    private final IOFunction<DataFileMeta, RecordReader<KeyValue>> fileReaderFactory;
    private final Supplier<File> localFileFactory;
    private final LookupStoreFactory lookupStoreFactory;
    private final Cache<String, LookupFile> lookupFiles;
    private final Function<Long, BloomFilter.Builder> bfGenerator;

    public LookupLevels(Levels levels, Comparator<InternalRow> keyComparator, RowType keyType, RowType valueType, IOFunction<DataFileMeta, RecordReader<KeyValue>> fileReaderFactory, Supplier<File> localFileFactory, LookupStoreFactory lookupStoreFactory, Duration fileRetention, MemorySize maxDiskSize, Function<Long, BloomFilter.Builder> bfGenerator) {
        this.levels = levels;
        this.keyComparator = keyComparator;
        this.keySerializer = new RowCompactedSerializer(keyType);
        this.valueSerializer = new RowCompactedSerializer(valueType);
        this.fileReaderFactory = fileReaderFactory;
        this.localFileFactory = localFileFactory;
        this.lookupStoreFactory = lookupStoreFactory;
        this.lookupFiles = Caffeine.newBuilder().expireAfterAccess(fileRetention).maximumWeight(maxDiskSize.getKibiBytes()).weigher(this::fileWeigh).removalListener(this::removalCallback).executor(MoreExecutors.directExecutor()).build();
        this.bfGenerator = bfGenerator;
        levels.addDropFileCallback(this);
    }

    public Levels getLevels() {
        return this.levels;
    }

    @VisibleForTesting
    Cache<String, LookupFile> lookupFiles() {
        return this.lookupFiles;
    }

    @Override
    public void notifyDropFile(String file) {
        this.lookupFiles.invalidate(file);
    }

    @Nullable
    public KeyValue lookup(InternalRow key, int startLevel) throws IOException {
        return LookupUtils.lookup(this.levels, key, startLevel, this::lookup, this::lookupLevel0);
    }

    @Nullable
    private KeyValue lookupLevel0(InternalRow key, TreeSet<DataFileMeta> level0) throws IOException {
        return LookupUtils.lookupLevel0(this.keyComparator, key, level0, this::lookup);
    }

    @Nullable
    private KeyValue lookup(InternalRow key, SortedRun level) throws IOException {
        return LookupUtils.lookup(this.keyComparator, key, level, this::lookup);
    }

    @Nullable
    private KeyValue lookup(InternalRow key, DataFileMeta file) throws IOException {
        LookupFile lookupFile = this.lookupFiles.getIfPresent(file.fileName());
        byte[] keyBytes = this.keySerializer.serializeToBytes(key);
        while (lookupFile == null || lookupFile.isClosed) {
            lookupFile = this.createLookupFile(file);
            this.lookupFiles.put(file.fileName(), lookupFile);
        }
        byte[] valueBytes = lookupFile.get(keyBytes);
        if (valueBytes == null) {
            return null;
        }
        InternalRow value = this.valueSerializer.deserialize(valueBytes);
        long sequenceNumber = MemorySegment.wrap(valueBytes).getLong(valueBytes.length - 9);
        RowKind rowKind = RowKind.fromByteValue(valueBytes[valueBytes.length - 1]);
        return new KeyValue().replace(key, sequenceNumber, rowKind, value).setLevel(lookupFile.remoteFile().level());
    }

    private int fileWeigh(String file, LookupFile lookupFile) {
        return LookupUtils.fileKibiBytes(lookupFile.localFile);
    }

    private void removalCallback(String key, LookupFile file, RemovalCause cause) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private LookupFile createLookupFile(DataFileMeta file) throws IOException {
        File localFile = this.localFileFactory.get();
        if (!localFile.createNewFile()) {
            throw new IOException("Can not create new file: " + localFile);
        }
        try (LookupStoreWriter kvWriter = this.lookupStoreFactory.createWriter(localFile, this.bfGenerator.apply(file.rowCount()));
             RecordReader<KeyValue> reader = this.fileReaderFactory.apply(file);){
            RecordReader.RecordIterator<KeyValue> batch;
            DataOutputSerializer valueOut = new DataOutputSerializer(32);
            while ((batch = reader.readBatch()) != null) {
                KeyValue kv;
                while ((kv = batch.next()) != null) {
                    byte[] keyBytes = this.keySerializer.serializeToBytes(kv.key());
                    valueOut.clear();
                    valueOut.write(this.valueSerializer.serializeToBytes(kv.value()));
                    valueOut.writeLong(kv.sequenceNumber());
                    valueOut.writeByte(kv.valueKind().toByteValue());
                    byte[] valueBytes = valueOut.getCopyOfBuffer();
                    kvWriter.put(keyBytes, valueBytes);
                }
                batch.releaseBatch();
            }
        }
        catch (IOException e) {
            FileIOUtils.deleteFileOrDirectory(localFile);
            throw e;
        }
        return new LookupFile(localFile, file, this.lookupStoreFactory.createReader(localFile));
    }

    @Override
    public void close() throws IOException {
        this.lookupFiles.invalidateAll();
    }

    private static class LookupFile
    implements Closeable {
        private final File localFile;
        private final DataFileMeta remoteFile;
        private final LookupStoreReader reader;
        private boolean isClosed = false;

        public LookupFile(File localFile, DataFileMeta remoteFile, LookupStoreReader reader) {
            this.localFile = localFile;
            this.remoteFile = remoteFile;
            this.reader = reader;
        }

        @Nullable
        public byte[] get(byte[] key) throws IOException {
            Preconditions.checkArgument(!this.isClosed);
            return this.reader.lookup(key);
        }

        public DataFileMeta remoteFile() {
            return this.remoteFile;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.isClosed = true;
            FileIOUtils.deleteFileOrDirectory(this.localFile);
        }
    }
}

