/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.Projection;

public class AggregateMergeFunction
implements MergeFunction<KeyValue> {
    private final InternalRow.FieldGetter[] getters;
    private final FieldAggregator[] aggregators;
    private KeyValue latestKv;
    private GenericRow row;
    private KeyValue reused;

    public AggregateMergeFunction(InternalRow.FieldGetter[] getters, FieldAggregator[] aggregators) {
        this.getters = getters;
        this.aggregators = aggregators;
    }

    @Override
    public void reset() {
        this.latestKv = null;
        this.row = new GenericRow(this.getters.length);
        Arrays.stream(this.aggregators).forEach(FieldAggregator::reset);
    }

    @Override
    public void add(KeyValue kv) {
        this.latestKv = kv;
        boolean isRetract = kv.valueKind() != RowKind.INSERT && kv.valueKind() != RowKind.UPDATE_AFTER;
        for (int i = 0; i < this.getters.length; ++i) {
            FieldAggregator fieldAggregator = this.aggregators[i];
            Object accumulator = this.getters[i].getFieldOrNull(this.row);
            Object inputField = this.getters[i].getFieldOrNull(kv.value());
            Object mergedField = isRetract ? fieldAggregator.retract(accumulator, inputField) : fieldAggregator.agg(accumulator, inputField);
            this.row.setField(i, mergedField);
        }
    }

    @Override
    @Nullable
    public KeyValue getResult() {
        Preconditions.checkNotNull(this.latestKv, "Trying to get result from merge function without any input. This is unexpected.");
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        return this.reused.replace(this.latestKv.key(), this.latestKv.sequenceNumber(), RowKind.INSERT, this.row);
    }

    public static MergeFunctionFactory<KeyValue> factory(Options conf, List<String> tableNames, List<DataType> tableTypes, List<String> primaryKeys) {
        return new Factory(conf, tableNames, tableTypes, primaryKeys);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final CoreOptions options;
        private final List<String> tableNames;
        private final List<DataType> tableTypes;
        private final List<String> primaryKeys;

        private Factory(Options conf, List<String> tableNames, List<DataType> tableTypes, List<String> primaryKeys) {
            this.options = new CoreOptions(conf);
            this.tableNames = tableNames;
            this.tableTypes = tableTypes;
            this.primaryKeys = primaryKeys;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            List<String> fieldNames = this.tableNames;
            List<DataType> fieldTypes = this.tableTypes;
            if (projection != null) {
                Projection project = Projection.of(projection);
                fieldNames = project.project(this.tableNames);
                fieldTypes = project.project(this.tableTypes);
            }
            FieldAggregator[] fieldAggregators = new FieldAggregator[fieldNames.size()];
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName = fieldNames.get(i);
                DataType fieldType = fieldTypes.get(i);
                boolean isPrimaryKey = this.primaryKeys.contains(fieldName);
                String strAggFunc = this.options.fieldAggFunc(fieldName);
                boolean ignoreRetract = this.options.fieldAggIgnoreRetract(fieldName);
                fieldAggregators[i] = FieldAggregator.createFieldAggregator(fieldType, strAggFunc, ignoreRetract, isPrimaryKey, this.options, fieldName);
            }
            return new AggregateMergeFunction(InternalRowUtils.createFieldGetters(fieldTypes), fieldAggregators);
        }
    }
}

