/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.spark.SparkSource;
import org.apache.paimon.spark.catalog.SparkBaseCatalog;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkGenericCatalog<T extends TableCatalog & SupportsNamespaces>
extends SparkBaseCatalog
implements CatalogExtension {
    private static final Logger LOG = LoggerFactory.getLogger(SparkGenericCatalog.class);
    private static final String[] DEFAULT_NAMESPACE = new String[]{"default"};
    private String catalogName = null;
    private SparkCatalog sparkCatalog = null;
    private T sessionCatalog = null;

    @Override
    public Catalog paimonCatalog() {
        return this.sparkCatalog.paimonCatalog();
    }

    public String[] defaultNamespace() {
        return DEFAULT_NAMESPACE;
    }

    public String[][] listNamespaces() throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).listNamespaces();
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).listNamespaces(namespace);
    }

    public boolean namespaceExists(String[] namespace) {
        return ((SupportsNamespaces)this.getSessionCatalog()).namespaceExists(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).loadNamespaceMetadata(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        ((SupportsNamespaces)this.getSessionCatalog()).createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        ((SupportsNamespaces)this.getSessionCatalog()).alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException, NonEmptyNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).dropNamespace(namespace, cascade);
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        return this.getSessionCatalog().listTables(namespace);
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        try {
            return this.sparkCatalog.loadTable(ident);
        }
        catch (NoSuchTableException e) {
            return this.throwsOldIfExceptionHappens(() -> this.getSessionCatalog().loadTable(ident), e);
        }
    }

    public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        try {
            return this.sparkCatalog.loadTable(ident, version);
        }
        catch (NoSuchTableException e) {
            return this.throwsOldIfExceptionHappens(() -> this.getSessionCatalog().loadTable(ident, version), e);
        }
    }

    public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        try {
            return this.sparkCatalog.loadTable(ident, timestamp);
        }
        catch (NoSuchTableException e) {
            return this.throwsOldIfExceptionHappens(() -> this.getSessionCatalog().loadTable(ident, timestamp), e);
        }
    }

    public void invalidateTable(Identifier ident) {
        this.sparkCatalog.invalidateTable(ident);
        this.getSessionCatalog().invalidateTable(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        String provider = properties.get("provider");
        if (this.usePaimon(provider)) {
            return this.sparkCatalog.createTable(ident, schema, partitions, (Map)properties);
        }
        return this.getSessionCatalog().createTable(ident, schema, partitions, properties);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        if (this.sparkCatalog.tableExists(ident)) {
            return this.sparkCatalog.alterTable(ident, changes);
        }
        return this.getSessionCatalog().alterTable(ident, changes);
    }

    public boolean dropTable(Identifier ident) {
        return this.sparkCatalog.dropTable(ident) || this.getSessionCatalog().dropTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        return this.sparkCatalog.purgeTable(ident) || this.getSessionCatalog().purgeTable(ident);
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        if (this.sparkCatalog.tableExists(from)) {
            this.sparkCatalog.renameTable(from, to);
        } else {
            this.getSessionCatalog().renameTable(from, to);
        }
    }

    public final void initialize(String name, CaseInsensitiveStringMap options) {
        String envHmsUri;
        String uri;
        Configuration hadoopConf = SparkSession.active().sessionState().newHadoopConf();
        if (options.containsKey((Object)CatalogOptions.METASTORE.key()) && options.get((Object)CatalogOptions.METASTORE.key()).equalsIgnoreCase("hive") && (uri = options.get((Object)CatalogOptions.URI.key())) != null && (envHmsUri = hadoopConf.get("hive.metastore.uris", null)) != null) {
            Preconditions.checkArgument(uri.equals(envHmsUri), "Inconsistent Hive metastore URIs: %s (Spark session) != %s (spark_catalog)", envHmsUri, uri);
        }
        if (SparkSession.active().sharedState().externalCatalog().unwrapped() instanceof InMemoryCatalog) {
            LOG.warn("InMemoryCatalog here may cause bad effect.");
        }
        this.catalogName = name;
        this.sparkCatalog = new SparkCatalog();
        this.sparkCatalog.initialize(name, this.autoFillConfigurations(options, SparkSession.active().sessionState().conf(), hadoopConf));
    }

    private CaseInsensitiveStringMap autoFillConfigurations(CaseInsensitiveStringMap options, SQLConf sqlConf, Configuration hadoopConf) {
        HashMap<String, String> newOptions = new HashMap<String, String>(options.asCaseSensitiveMap());
        this.fillAliyunConfigurations(newOptions, hadoopConf);
        this.fillCommonConfigurations(newOptions, sqlConf);
        return new CaseInsensitiveStringMap(newOptions);
    }

    private void fillAliyunConfigurations(Map<String, String> options, Configuration hadoopConf) {
        String aliyunEMRHiveMetastoreType;
        if (!options.containsKey(CatalogOptions.METASTORE.key()) && "dlf".equalsIgnoreCase(aliyunEMRHiveMetastoreType = hadoopConf.get("hive.metastore.type", null))) {
            options.put(CatalogOptions.METASTORE.key(), "dlf");
        }
    }

    private void fillCommonConfigurations(Map<String, String> options, SQLConf sqlConf) {
        String metastore;
        if (!options.containsKey(CatalogOptions.WAREHOUSE.key())) {
            String warehouse = sqlConf.warehousePath();
            options.put(CatalogOptions.WAREHOUSE.key(), warehouse);
        }
        if (!options.containsKey(CatalogOptions.METASTORE.key()) && "hive".equals(metastore = (String)sqlConf.getConf(StaticSQLConf.CATALOG_IMPLEMENTATION()))) {
            options.put(CatalogOptions.METASTORE.key(), metastore);
        }
    }

    public void setDelegateCatalog(CatalogPlugin sparkSessionCatalog) {
        if (!(sparkSessionCatalog instanceof TableCatalog) || !(sparkSessionCatalog instanceof SupportsNamespaces)) {
            throw new IllegalArgumentException("Invalid session catalog: " + sparkSessionCatalog);
        }
        this.sessionCatalog = (TableCatalog)sparkSessionCatalog;
    }

    public String name() {
        return this.catalogName;
    }

    private boolean usePaimon(String provider) {
        return provider == null || SparkSource.NAME().equalsIgnoreCase(provider);
    }

    private T getSessionCatalog() {
        Preconditions.checkNotNull(this.sessionCatalog, "Delegated SessionCatalog is missing. Please make sure your are replacing Spark's default catalog, named 'spark_catalog'.");
        return this.sessionCatalog;
    }

    public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        if (namespace.length == 0 || SparkGenericCatalog.isSystemNamespace(namespace) || this.namespaceExists(namespace)) {
            return new Identifier[0];
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        throw new NoSuchFunctionException(ident);
    }

    private static boolean isSystemNamespace(String[] namespace) {
        return namespace.length == 1 && namespace[0].equalsIgnoreCase("system");
    }

    private Table throwsOldIfExceptionHappens(Callable<Table> call, NoSuchTableException e) throws NoSuchTableException {
        try {
            return call.call();
        }
        catch (Exception exception) {
            throw e;
        }
    }
}

