/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.function.Function;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.SparkUtils;
import org.apache.paimon.spark.procedure.Procedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import scala.Option;

abstract class BaseProcedure
implements Procedure {
    private final SparkSession spark = SparkSession.active();
    private final TableCatalog tableCatalog;

    protected BaseProcedure(TableCatalog tableCatalog) {
        this.tableCatalog = tableCatalog;
    }

    protected Identifier toIdentifier(String identifierAsString, String argName) {
        SparkUtils.CatalogAndIdentifier catalogAndIdentifier = this.toCatalogAndIdentifier(identifierAsString, argName, (CatalogPlugin)this.tableCatalog);
        Preconditions.checkArgument(catalogAndIdentifier.catalog().equals(this.tableCatalog), "Cannot run procedure in catalog '%s': '%s' is a table in catalog '%s'", this.tableCatalog.name(), identifierAsString, catalogAndIdentifier.catalog().name());
        return catalogAndIdentifier.identifier();
    }

    protected SparkUtils.CatalogAndIdentifier toCatalogAndIdentifier(String identifierAsString, String argName, CatalogPlugin catalog) {
        Preconditions.checkArgument(identifierAsString != null && !identifierAsString.isEmpty(), "Cannot handle an empty identifier for argument %s", argName);
        return SparkUtils.catalogAndIdentifier("identifier for arg " + argName, this.spark, identifierAsString, catalog);
    }

    protected <T> T modifyPaimonTable(Identifier ident, Function<Table, T> func) {
        return this.execute(ident, true, func);
    }

    private <T> T execute(Identifier ident, boolean refreshSparkCache, Function<Table, T> func) {
        SparkTable sparkTable = this.loadSparkTable(ident);
        Table table = sparkTable.getTable();
        T result = func.apply(table);
        if (refreshSparkCache) {
            this.refreshSparkCache(ident, sparkTable);
        }
        return result;
    }

    protected SparkTable loadSparkTable(Identifier ident) {
        try {
            org.apache.spark.sql.connector.catalog.Table table = this.tableCatalog.loadTable(ident);
            Preconditions.checkArgument(table instanceof SparkTable, "%s is not %s", ident, SparkTable.class.getName());
            return (SparkTable)table;
        }
        catch (NoSuchTableException e) {
            String errMsg = String.format("Couldn't load table '%s' in catalog '%s'", ident, this.tableCatalog.name());
            throw new RuntimeException(errMsg, e);
        }
    }

    protected void refreshSparkCache(Identifier ident, org.apache.spark.sql.connector.catalog.Table table) {
        CacheManager cacheManager = this.spark.sharedState().cacheManager();
        DataSourceV2Relation relation = DataSourceV2Relation.create((org.apache.spark.sql.connector.catalog.Table)table, (Option)Option.apply((Object)this.tableCatalog), (Option)Option.apply((Object)ident));
        cacheManager.recacheByPlan(this.spark, (LogicalPlan)relation);
    }

    protected InternalRow newInternalRow(Object ... values) {
        return new GenericInternalRow(values);
    }

    protected SparkSession spark() {
        return this.spark;
    }

    protected TableCatalog tableCatalog() {
        return this.tableCatalog;
    }

    protected static abstract class Builder<T extends BaseProcedure>
    implements ProcedureBuilder {
        private TableCatalog tableCatalog;

        protected Builder() {
        }

        @Override
        public Builder<T> withTableCatalog(TableCatalog newTableCatalog) {
            this.tableCatalog = newTableCatalog;
            return this;
        }

        public T build() {
            return this.doBuild();
        }

        protected abstract T doBuild();

        TableCatalog tableCatalog() {
            return this.tableCatalog;
        }
    }
}

