/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class DeleteTagProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("tag", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected DeleteTagProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String tag = args.getString(1);
        return this.modifyPaimonTable(tableIdent, table -> {
            table.deleteTag(tag);
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<DeleteTagProcedure>(){

            @Override
            public DeleteTagProcedure doBuild() {
                return new DeleteTagProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "DeleteTagProcedure";
    }
}

