/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.catalog.Catalogs$;
import org.apache.paimon.spark.catalyst.plans.logical.IncrementalQuery;
import org.apache.paimon.spark.catalyst.plans.logical.PaimonTableValueFunction;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistryBase$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public final class PaimonTableValuedFunctions$ {
    public static PaimonTableValuedFunctions$ MODULE$;
    private final String INCREMENTAL_QUERY;
    private final Seq<String> supportedFnNames;

    static {
        new PaimonTableValuedFunctions$();
    }

    public String INCREMENTAL_QUERY() {
        return this.INCREMENTAL_QUERY;
    }

    public Seq<String> supportedFnNames() {
        return this.supportedFnNames;
    }

    public Tuple3<FunctionIdentifier, ExpressionInfo, Function1<Seq<Expression>, LogicalPlan>> getTableValueFunctionInjection(String fnName) {
        String string = fnName;
        String string2 = this.INCREMENTAL_QUERY();
        String string3 = string;
        if (string2 != null ? !string2.equals(string3) : string3 != null) {
            throw new Exception(new StringBuilder(50).append("Function ").append(fnName).append(" isn't a supported table valued function.").toString());
        }
        Tuple2 tuple2 = FunctionRegistryBase$.MODULE$.build(fnName, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(IncrementalQuery.class));
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ExpressionInfo info = (ExpressionInfo)tuple22._1();
        Function1 builder = (Function1)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)info, (Object)builder);
        Tuple2 tuple24 = tuple23;
        ExpressionInfo info2 = (ExpressionInfo)tuple24._1();
        Function1 builder2 = (Function1)tuple24._2();
        FunctionIdentifier ident = FunctionIdentifier$.MODULE$.apply(fnName);
        return new Tuple3((Object)ident, (Object)info2, (Object)builder2);
    }

    public LogicalPlan resolvePaimonTableValuedFunction(SparkSession spark, PaimonTableValueFunction tvf) {
        Seq args = tvf.expressions();
        SessionState sessionState = spark.sessionState();
        CatalogManager catalogManager = sessionState.catalogManager();
        SparkCatalog sparkCatalog = new SparkCatalog();
        String currentCatalog = catalogManager.currentCatalog().name();
        sparkCatalog.initialize(currentCatalog, Catalogs$.MODULE$.catalogOptions(currentCatalog, spark.sessionState().conf()));
        Expression qual$1 = (Expression)args.head();
        InternalRow x$1 = qual$1.eval$default$1();
        TableIdentifier tableId = sessionState.sqlParser().parseTableIdentifier(qual$1.eval(x$1).toString());
        String[] namespace = (String[])tableId.database().map((Function1 & Serializable & scala.Serializable)x$2 -> (String[])((Object[])new String[]{x$2})).getOrElse((Function0 & Serializable & scala.Serializable)() -> catalogManager.currentNamespace());
        Identifier ident = Identifier.of((String[])namespace, (String)tableId.table());
        SparkTable sparkTable = sparkCatalog.loadTable(ident);
        Map<String, String> options = tvf.parseArgs((Seq<Expression>)((Seq)args.tail()));
        return DataSourceV2Relation$.MODULE$.create((Table)sparkTable, (Option)new Some((Object)sparkCatalog), (Option)new Some((Object)ident), new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava()));
    }

    private PaimonTableValuedFunctions$() {
        MODULE$ = this;
        this.INCREMENTAL_QUERY = "paimon_incremental_query";
        this.supportedFnNames = (Seq)new .colon.colon((Object)this.INCREMENTAL_QUERY(), (List)Nil$.MODULE$);
    }
}

