/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class ExpireSnapshotsProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("retain_max", DataTypes.IntegerType), ProcedureParameter.optional("retain_min", DataTypes.IntegerType), ProcedureParameter.optional("older_than", DataTypes.TimestampType), ProcedureParameter.optional("max_deletes", DataTypes.IntegerType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("deleted_snapshots_count", DataTypes.IntegerType, false, Metadata.empty())});

    protected ExpireSnapshotsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Integer retainMax = args.isNullAt(1) ? null : Integer.valueOf(args.getInt(1));
        Integer retainMin = args.isNullAt(2) ? null : Integer.valueOf(args.getInt(2));
        Long olderThanMills = args.isNullAt(3) ? null : Long.valueOf(args.getLong(3) / 1000L);
        Integer maxDeletes = args.isNullAt(4) ? null : Integer.valueOf(args.getInt(4));
        return this.modifyPaimonTable(tableIdent, table -> {
            ExpireSnapshots expireSnapshots = table.newExpireSnapshots();
            if (retainMax != null) {
                expireSnapshots.retainMax(retainMax);
            }
            if (retainMin != null) {
                expireSnapshots.retainMin(retainMin);
            }
            if (olderThanMills != null) {
                expireSnapshots.olderThanMills(olderThanMills);
            }
            if (maxDeletes != null) {
                expireSnapshots.maxDeletes(maxDeletes);
            }
            int deleted = expireSnapshots.expire();
            return new InternalRow[]{this.newInternalRow(deleted)};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ExpireSnapshotsProcedure>(){

            @Override
            public ExpireSnapshotsProcedure doBuild() {
                return new ExpireSnapshotsProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ExpireSnapshotsProcedure";
    }
}

