/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.TableMigrationUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class MigrateTableProcedure
extends BaseProcedure {
    private static final String TMP_TBL_SUFFIX = "_paimon_";
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("source_type", DataTypes.StringType), ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("options", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected MigrateTableProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String format = args.getString(0);
        String sourceTable = args.getString(1);
        String properties = args.isNullAt(2) ? null : args.getString(2);
        Identifier sourceTableId = Identifier.fromString(sourceTable);
        Identifier tmpTableId = Identifier.fromString(sourceTable + TMP_TBL_SUFFIX);
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        try {
            Migrator migrator = TableMigrationUtils.getImporter(format, paimonCatalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), tmpTableId.getDatabaseName(), tmpTableId.getObjectName(), ParameterUtils.parseCommaSeparatedKeyValues(properties));
            migrator.executeMigrate();
            paimonCatalog.renameTable(tmpTableId, sourceTableId, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Call migrate_table error", e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<MigrateTableProcedure>(){

            @Override
            public MigrateTableProcedure doBuild() {
                return new MigrateTableProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "MigrateTableProcedure";
    }
}

