/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.utils.JsonSerdeUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Changelog
extends Snapshot {
    public Changelog(Snapshot snapshot) {
        this(snapshot.version(), snapshot.id(), snapshot.schemaId(), snapshot.baseManifestList(), snapshot.deltaManifestList(), snapshot.changelogManifestList(), snapshot.indexManifest(), snapshot.commitUser(), snapshot.commitIdentifier(), snapshot.commitKind(), snapshot.timeMillis(), snapshot.logOffsets(), snapshot.totalRecordCount(), snapshot.deltaRecordCount(), snapshot.changelogRecordCount(), snapshot.watermark(), snapshot.statistics());
    }

    @JsonCreator
    public Changelog(@JsonProperty(value="version") @Nullable Integer version, @JsonProperty(value="id") long id, @JsonProperty(value="schemaId") long schemaId, @JsonProperty(value="baseManifestList") String baseManifestList, @JsonProperty(value="deltaManifestList") String deltaManifestList, @JsonProperty(value="changelogManifestList") @Nullable String changelogManifestList, @JsonProperty(value="indexManifest") @Nullable String indexManifest, @JsonProperty(value="commitUser") String commitUser, @JsonProperty(value="commitIdentifier") long commitIdentifier, @JsonProperty(value="commitKind") Snapshot.CommitKind commitKind, @JsonProperty(value="timeMillis") long timeMillis, @JsonProperty(value="logOffsets") Map<Integer, Long> logOffsets, @JsonProperty(value="totalRecordCount") @Nullable Long totalRecordCount, @JsonProperty(value="deltaRecordCount") @Nullable Long deltaRecordCount, @JsonProperty(value="changelogRecordCount") @Nullable Long changelogRecordCount, @JsonProperty(value="watermark") @Nullable Long watermark, @JsonProperty(value="statistics") @Nullable String statistics) {
        super(version, id, schemaId, baseManifestList, deltaManifestList, changelogManifestList, indexManifest, commitUser, commitIdentifier, commitKind, timeMillis, logOffsets, totalRecordCount, deltaRecordCount, changelogRecordCount, watermark, statistics);
    }

    public static Changelog fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Changelog.class);
    }

    public static Changelog fromPath(FileIO fileIO, Path path) {
        try {
            String json = fileIO.readFileUtf8(path);
            return Changelog.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to read changelog from path " + path, e);
        }
    }
}

