/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import java.util.Arrays;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.statistics.NoneFieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public class TableStatsCollector {
    private final RowDataToObjectArrayConverter converter;
    private final FieldStatsCollector[] statsCollectors;
    private final Serializer<Object>[] fieldSerializers;
    private final boolean isDisabled;

    public TableStatsCollector(RowType rowType) {
        this(rowType, FieldStatsCollector.createFullStatsFactories(rowType.getFieldCount()));
    }

    public TableStatsCollector(RowType rowType, FieldStatsCollector.Factory[] collectorFactory) {
        int numFields = rowType.getFieldCount();
        Preconditions.checkArgument(numFields == collectorFactory.length, "numFields %s should equal to stats length %s.", numFields, collectorFactory.length);
        this.statsCollectors = FieldStatsCollector.create(collectorFactory);
        this.converter = new RowDataToObjectArrayConverter(rowType);
        this.fieldSerializers = new Serializer[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fieldSerializers[i] = InternalSerializers.create(rowType.getTypeAt(i));
        }
        this.isDisabled = Arrays.stream(this.statsCollectors).allMatch(p -> p instanceof NoneFieldStatsCollector);
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void collect(InternalRow row) {
        Object[] objects = this.converter.convert(row);
        for (int i = 0; i < row.getFieldCount(); ++i) {
            FieldStatsCollector collector = this.statsCollectors[i];
            Object obj = objects[i];
            collector.collect(obj, this.fieldSerializers[i]);
        }
    }

    public FieldStats[] extract() {
        FieldStats[] stats = new FieldStats[this.statsCollectors.length];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = this.statsCollectors[i].result();
        }
        return stats;
    }
}

