/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.manifest.ManifestEntrySerializer;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.SerializationUtils;

public class ManifestEntry
implements FileEntry {
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final int totalBuckets;
    private final DataFileMeta file;

    public ManifestEntry(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, DataFileMeta file) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.totalBuckets = totalBuckets;
        this.file = file;
    }

    @Override
    public FileKind kind() {
        return this.kind;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    @Override
    public int level() {
        return this.file.level();
    }

    @Override
    public String fileName() {
        return this.file.fileName();
    }

    @Override
    public BinaryRow minKey() {
        return this.file.minKey();
    }

    @Override
    public BinaryRow maxKey() {
        return this.file.maxKey();
    }

    public int totalBuckets() {
        return this.totalBuckets;
    }

    public DataFileMeta file() {
        return this.file;
    }

    @Override
    public FileEntry.Identifier identifier() {
        return new FileEntry.Identifier(this.partition, this.bucket, this.file.level(), this.file.fileName());
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_KIND", new TinyIntType(false)));
        fields.add(new DataField(1, "_PARTITION", SerializationUtils.newBytesType(false)));
        fields.add(new DataField(2, "_BUCKET", new IntType(false)));
        fields.add(new DataField(3, "_TOTAL_BUCKETS", new IntType(false)));
        fields.add(new DataField(4, "_FILE", DataFileMeta.schema()));
        return new RowType(fields);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestEntry)) {
            return false;
        }
        ManifestEntry that = (ManifestEntry)o;
        return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.totalBuckets == that.totalBuckets && Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public String toString() {
        return String.format("{%s, %s, %d, %d, %s}", new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public static Filter<InternalRow> createCacheRowFilter(@Nullable ManifestCacheFilter manifestCacheFilter, int numOfBuckets) {
        if (manifestCacheFilter == null) {
            return Filter.alwaysTrue();
        }
        Function<InternalRow, BinaryRow> partitionGetter = ManifestEntrySerializer.partitionGetter();
        Function<InternalRow, Integer> bucketGetter = ManifestEntrySerializer.bucketGetter();
        Function<InternalRow, Integer> totalBucketGetter = ManifestEntrySerializer.totalBucketGetter();
        return row -> {
            if (numOfBuckets != (Integer)totalBucketGetter.apply((InternalRow)row)) {
                return true;
            }
            return manifestCacheFilter.test((BinaryRow)partitionGetter.apply((InternalRow)row), (Integer)bucketGetter.apply((InternalRow)row));
        };
    }

    public static Filter<InternalRow> createEntryRowFilter(@Nullable PartitionPredicate partitionFilter, @Nullable Filter<Integer> bucketFilter, int numOfBuckets) {
        Function<InternalRow, BinaryRow> partitionGetter = ManifestEntrySerializer.partitionGetter();
        Function<InternalRow, Integer> bucketGetter = ManifestEntrySerializer.bucketGetter();
        Function<InternalRow, Integer> totalBucketGetter = ManifestEntrySerializer.totalBucketGetter();
        return row -> {
            if (partitionFilter != null && !partitionFilter.test((BinaryRow)partitionGetter.apply((InternalRow)row))) {
                return false;
            }
            if (bucketFilter != null && numOfBuckets == (Integer)totalBucketGetter.apply((InternalRow)row)) {
                return bucketFilter.test((Integer)bucketGetter.apply((InternalRow)row));
            }
            return true;
        };
    }
}

