/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.disk.ChannelReaderInputView;
import org.apache.paimon.disk.ChannelReaderInputViewIterator;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.sort.AbstractBinaryExternalMerger;
import org.apache.paimon.sort.SpillChannelManager;
import org.apache.paimon.utils.MutableObjectIterator;

public class BinaryExternalMerger
extends AbstractBinaryExternalMerger<BinaryRow> {
    private final BinaryRowSerializer serializer;
    private final RecordComparator comparator;

    public BinaryExternalMerger(IOManager ioManager, int pageSize, int maxFanIn, SpillChannelManager channelManager, BinaryRowSerializer serializer, RecordComparator comparator, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) {
        super(ioManager, pageSize, maxFanIn, channelManager, compressionCodecFactory, compressionBlockSize);
        this.serializer = serializer;
        this.comparator = comparator;
    }

    @Override
    protected MutableObjectIterator<BinaryRow> channelReaderInputViewIterator(ChannelReaderInputView inView) {
        return new ChannelReaderInputViewIterator(inView, null, this.serializer.duplicate());
    }

    @Override
    protected Comparator<BinaryRow> mergeComparator() {
        return this.comparator::compare;
    }

    @Override
    protected List<BinaryRow> mergeReusedEntries(int size) {
        ArrayList<BinaryRow> reused = new ArrayList<BinaryRow>(size);
        for (int i = 0; i < size; ++i) {
            reused.add(this.serializer.createInstance());
        }
        return reused;
    }

    @Override
    protected void writeMergingOutput(MutableObjectIterator<BinaryRow> mergeIterator, AbstractPagedOutputView output) throws IOException {
        BinaryRow rec = this.serializer.createInstance();
        while ((rec = mergeIterator.next(rec)) != null) {
            this.serializer.serialize(rec, (DataOutputView)output);
        }
    }
}

