/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import java.io.IOException;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.PathFactory;

public class IcebergPathFactory {
    private final Path metadataDirectory;
    private final String uuid;
    private int manifestFileCount;
    private int manifestListCount;

    public IcebergPathFactory(Path root) {
        this.metadataDirectory = new Path(root, "metadata");
        this.uuid = UUID.randomUUID().toString();
    }

    public Path metadataDirectory() {
        return this.metadataDirectory;
    }

    public Path newManifestFile() {
        ++this.manifestFileCount;
        return this.toManifestFilePath(this.uuid + "-m" + this.manifestFileCount + ".avro");
    }

    public Path toManifestFilePath(String manifestFileName) {
        return new Path(this.metadataDirectory(), manifestFileName);
    }

    public Path newManifestListFile() {
        ++this.manifestListCount;
        return this.toManifestListPath("snap-" + this.manifestListCount + "-" + this.uuid + ".avro");
    }

    public Path toManifestListPath(String manifestListName) {
        return new Path(this.metadataDirectory(), manifestListName);
    }

    public Path toMetadataPath(long snapshotId) {
        return new Path(this.metadataDirectory(), String.format("v%d.metadata.json", snapshotId));
    }

    public Stream<Path> getAllMetadataPathBefore(FileIO fileIO, long snapshotId) throws IOException {
        return FileUtils.listVersionedFileStatus(fileIO, this.metadataDirectory, "v").map(FileStatus::getPath).filter(path -> {
            try {
                String id = path.getName().split("\\.")[0].substring(1);
                return Long.parseLong(id) < snapshotId;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public PathFactory manifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return IcebergPathFactory.this.newManifestFile();
            }

            @Override
            public Path toPath(String fileName) {
                return IcebergPathFactory.this.toManifestFilePath(fileName);
            }
        };
    }

    public PathFactory manifestListFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return IcebergPathFactory.this.newManifestListFile();
            }

            @Override
            public Path toPath(String fileName) {
                return IcebergPathFactory.this.toManifestListPath(fileName);
            }
        };
    }
}

