/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class IndexManifestEntrySerializer
extends VersionedObjectSerializer<IndexManifestEntry> {
    public IndexManifestEntrySerializer() {
        super(IndexManifestEntry.SCHEMA);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public InternalRow convertTo(IndexManifestEntry record) {
        IndexFileMeta indexFile = record.indexFile();
        return GenericRow.of(record.kind().toByteValue(), SerializationUtils.serializeBinaryRow(record.partition()), record.bucket(), BinaryString.fromString(indexFile.indexType()), BinaryString.fromString(indexFile.fileName()), indexFile.fileSize(), indexFile.rowCount(), record.indexFile().deletionVectorsRanges() == null ? null : IndexFileMetaSerializer.dvRangesToRowArrayData(record.indexFile().deletionVectorsRanges()));
    }

    @Override
    public IndexManifestEntry convertFrom(int version, InternalRow row) {
        if (version != 1) {
            throw new UnsupportedOperationException("Unsupported version: " + version);
        }
        return new IndexManifestEntry(FileKind.fromByteValue(row.getByte(0)), SerializationUtils.deserializeBinaryRow(row.getBinary(1)), row.getInt(2), new IndexFileMeta(row.getString(3).toString(), row.getString(4).toString(), row.getLong(5), row.getLong(6), row.isNullAt(7) ? null : IndexFileMetaSerializer.rowArrayDataToDvRanges(row.getArray(7))));
    }
}

