/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.TableMigrationUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class MigrateTableProcedure
extends BaseProcedure {
    private static final String TMP_TBL_SUFFIX = "_paimon_";
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("source_type", DataTypes.StringType), ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("options", DataTypes.StringType), ProcedureParameter.optional("delete_origin", DataTypes.BooleanType), ProcedureParameter.optional("target_table", DataTypes.StringType), ProcedureParameter.optional("options_map", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType))};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected MigrateTableProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String format = args.getString(0);
        String sourceTable = args.getString(1);
        String properties = args.isNullAt(2) ? null : args.getString(2);
        boolean deleteNeed = args.isNullAt(3) || args.getBoolean(3);
        String targetTable = args.isNullAt(4) ? null : args.getString(4);
        MapData mapData = args.isNullAt(5) ? null : args.getMap(5);
        Map<String, String> optionMap = MigrateTableProcedure.mapDataToHashMap(mapData);
        Identifier sourceTableId = Identifier.fromString(sourceTable);
        Identifier tmpTableId = StringUtils.isEmpty(targetTable) ? Identifier.fromString(sourceTable + TMP_TBL_SUFFIX) : Identifier.fromString(targetTable);
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        Map<String, String> options = ParameterUtils.parseCommaSeparatedKeyValues(properties);
        options.putAll(optionMap);
        try {
            Migrator migrator = TableMigrationUtils.getImporter(format, paimonCatalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), tmpTableId.getDatabaseName(), tmpTableId.getObjectName(), options);
            migrator.deleteOriginTable(deleteNeed);
            migrator.executeMigrate();
            if (StringUtils.isEmpty(targetTable)) {
                paimonCatalog.renameTable(tmpTableId, sourceTableId, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Call migrate_table error: " + e.getMessage(), e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public static Map<String, String> mapDataToHashMap(MapData mapData) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapData != null) {
            for (int index = 0; index < mapData.numElements(); ++index) {
                map.put(mapData.keyArray().getUTF8String(index).toString(), mapData.valueArray().getUTF8String(index).toString());
            }
        }
        return map;
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<MigrateTableProcedure>(){

            @Override
            public MigrateTableProcedure doBuild() {
                return new MigrateTableProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "MigrateTableProcedure";
    }
}

