/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class BranchesTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String BRANCHES = "branches";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "branch_name", SerializationUtils.newStringType(false)), new DataField(1, "created_from_tag", SerializationUtils.newStringType(true)), new DataField(2, "created_from_snapshot", new BigIntType(true)), new DataField(3, "create_time", new TimestampType(false, 3))));
    private final FileIO fileIO;
    private final Path location;

    public BranchesTable(FileStoreTable dataTable) {
        this(dataTable.fileIO(), dataTable.location());
    }

    public BranchesTable(FileIO fileIO, Path location) {
        this.fileIO = fileIO;
        this.location = location;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + BRANCHES;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Arrays.asList("branch_name", "tag_name");
    }

    @Override
    public InnerTableScan newScan() {
        return new BranchesScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new BranchesRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new BranchesTable(this.fileIO, this.location);
    }

    private static class BranchesRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;

        public BranchesRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            Iterator<InternalRow> rows;
            if (!(split instanceof BranchesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((BranchesSplit)split).location;
            FileStoreTable table = FileStoreTableFactory.create(this.fileIO, location);
            try {
                rows = this.branches(table).iterator();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private List<InternalRow> branches(FileStoreTable table) throws IOException {
            BranchManager branchManager = table.branchManager();
            SchemaManager schemaManager = new SchemaManager(this.fileIO, table.location());
            List paths = FileUtils.listVersionedDirectories(this.fileIO, branchManager.branchDirectory(), "branch-").map(status -> Pair.of(status.getPath(), status.getModificationTime())).collect(Collectors.toList());
            ArrayList<InternalRow> result = new ArrayList<InternalRow>();
            for (Pair path : paths) {
                String branchName = ((Path)path.getLeft()).getName().substring("branch-".length());
                String basedTag = null;
                Long basedSnapshotId = null;
                long creationTime = (Long)path.getRight();
                Optional<TableSchema> tableSchema = schemaManager.copyWithBranch(branchName).latest();
                if (tableSchema.isPresent()) {
                    FileStoreTable branchTable = FileStoreTableFactory.create(this.fileIO, new Path(BranchManager.branchPath(table.location(), branchName)));
                    SortedMap<Snapshot, List<String>> snapshotTags = branchTable.tagManager().tags();
                    Long earliestSnapshotId = branchTable.snapshotManager().earliestSnapshotId();
                    if (snapshotTags.isEmpty()) {
                        basedSnapshotId = earliestSnapshotId;
                    } else {
                        Snapshot snapshot = snapshotTags.firstKey();
                        if (Objects.equals(earliestSnapshotId, snapshot.id())) {
                            List tags = (List)snapshotTags.get(snapshot);
                            Preconditions.checkArgument(tags.size() == 1);
                            basedTag = (String)tags.get(0);
                            basedSnapshotId = snapshot.id();
                        } else {
                            basedSnapshotId = earliestSnapshotId;
                        }
                    }
                }
                result.add(GenericRow.of(BinaryString.fromString(branchName), BinaryString.fromString(basedTag), basedSnapshotId, Timestamp.fromLocalDateTime(DateTimeUtils.toLocalDateTime(creationTime))));
            }
            return result;
        }
    }

    private static class BranchesSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private BranchesSplit(Path location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BranchesSplit that = (BranchesSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class BranchesScan
    extends ReadOnceTableScan {
        private BranchesScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new BranchesSplit(BranchesTable.this.location));
        }
    }
}

