/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.utils.IntIterator;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;

public class IndexFileHandler {
    private final SnapshotManager snapshotManager;
    private final PathFactory pathFactory;
    private final IndexManifestFile indexManifestFile;
    private final HashIndexFile hashIndex;
    private final DeletionVectorsIndexFile deletionVectorsIndex;

    public IndexFileHandler(SnapshotManager snapshotManager, PathFactory pathFactory, IndexManifestFile indexManifestFile, HashIndexFile hashIndex, DeletionVectorsIndexFile deletionVectorsIndex) {
        this.snapshotManager = snapshotManager;
        this.pathFactory = pathFactory;
        this.indexManifestFile = indexManifestFile;
        this.hashIndex = hashIndex;
        this.deletionVectorsIndex = deletionVectorsIndex;
    }

    public DeletionVectorsIndexFile deletionVectorsIndex() {
        return this.deletionVectorsIndex;
    }

    public Optional<IndexFileMeta> scanHashIndex(Snapshot snapshot, BinaryRow partition, int bucket) {
        List<IndexFileMeta> result = this.scan(snapshot, "HASH", partition, bucket);
        if (result.size() > 1) {
            throw new IllegalArgumentException("Find multiple hash index files for one bucket: " + result);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }

    public Map<String, DeletionFile> scanDVIndex(@Nullable Snapshot snapshot, BinaryRow partition, int bucket) {
        if (snapshot == null) {
            return Collections.emptyMap();
        }
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null) {
            return Collections.emptyMap();
        }
        HashMap<String, DeletionFile> result = new HashMap<String, DeletionFile>();
        for (IndexManifestEntry file : this.indexManifestFile.read(indexManifest)) {
            IndexFileMeta meta = file.indexFile();
            if (!meta.indexType().equals("DELETION_VECTORS") || !file.partition().equals(partition) || file.bucket() != bucket) continue;
            LinkedHashMap<String, DeletionVectorMeta> dvMetas = meta.deletionVectorMetas();
            Preconditions.checkNotNull(dvMetas);
            for (DeletionVectorMeta dvMeta : dvMetas.values()) {
                result.put(dvMeta.dataFileName(), new DeletionFile(this.filePath(meta).toString(), dvMeta.offset(), dvMeta.length(), dvMeta.cardinality()));
            }
        }
        return result;
    }

    public List<IndexManifestEntry> scan(String indexType) {
        Snapshot snapshot = this.snapshotManager.latestSnapshot();
        if (snapshot == null) {
            return Collections.emptyList();
        }
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null) {
            return Collections.emptyList();
        }
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : this.indexManifestFile.read(indexManifest)) {
            if (!file.indexFile().indexType().equals(indexType)) continue;
            result.add(file);
        }
        return result;
    }

    public List<IndexFileMeta> scan(Snapshot snapshot, String indexType, BinaryRow partition, int bucket) {
        ArrayList<IndexFileMeta> result = new ArrayList<IndexFileMeta>();
        for (IndexManifestEntry file : this.scanEntries(snapshot, indexType, partition)) {
            if (file.bucket() != bucket) continue;
            result.add(file.indexFile());
        }
        return result;
    }

    public Map<Pair<BinaryRow, Integer>, List<IndexFileMeta>> scan(long snapshot, String indexType, Set<BinaryRow> partitions) {
        return this.scan(this.snapshotManager.snapshot(snapshot), indexType, partitions);
    }

    public Map<Pair<BinaryRow, Integer>, List<IndexFileMeta>> scan(Snapshot snapshot, String indexType, Set<BinaryRow> partitions) {
        HashMap<Pair<BinaryRow, Integer>, List<IndexFileMeta>> result = new HashMap<Pair<BinaryRow, Integer>, List<IndexFileMeta>>();
        for (IndexManifestEntry file : this.scanEntries(snapshot, indexType, partitions)) {
            result.computeIfAbsent(Pair.of(file.partition(), file.bucket()), k -> new ArrayList()).add(file.indexFile());
        }
        return result;
    }

    public List<IndexManifestEntry> scanEntries() {
        Snapshot snapshot = this.snapshotManager.latestSnapshot();
        if (snapshot == null || snapshot.indexManifest() == null) {
            return Collections.emptyList();
        }
        return this.indexManifestFile.read(snapshot.indexManifest());
    }

    public List<IndexManifestEntry> scanEntries(String indexType, BinaryRow partition) {
        Snapshot snapshot = this.snapshotManager.latestSnapshot();
        if (snapshot == null) {
            return Collections.emptyList();
        }
        return this.scanEntries(snapshot, indexType, partition);
    }

    public List<IndexManifestEntry> scanEntries(Snapshot snapshot, String indexType, BinaryRow partition) {
        return this.scanEntries(snapshot, indexType, Collections.singleton(partition));
    }

    public List<IndexManifestEntry> scanEntries(Snapshot snapshot, String indexType, Set<BinaryRow> partitions) {
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null) {
            return Collections.emptyList();
        }
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : this.indexManifestFile.read(indexManifest)) {
            if (!file.indexFile().indexType().equals(indexType) || !partitions.contains(file.partition())) continue;
            result.add(file);
        }
        return result;
    }

    public Path filePath(IndexFileMeta file) {
        return this.pathFactory.toPath(file.fileName());
    }

    public List<Integer> readHashIndexList(IndexFileMeta file) {
        return IntIterator.toIntList(this.readHashIndex(file));
    }

    public IntIterator readHashIndex(IndexFileMeta file) {
        if (!file.indexType().equals("HASH")) {
            throw new IllegalArgumentException("Input file is not hash index: " + file.indexType());
        }
        try {
            return this.hashIndex.read(file.fileName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexFileMeta writeHashIndex(int[] ints) {
        return this.writeHashIndex(ints.length, IntIterator.create(ints));
    }

    public IndexFileMeta writeHashIndex(int size, IntIterator iterator2) {
        String file;
        try {
            file = this.hashIndex.write(iterator2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new IndexFileMeta("HASH", file, this.hashIndex.fileSize(file), size);
    }

    public boolean existsManifest(String indexManifest) {
        return this.indexManifestFile.exists(indexManifest);
    }

    public List<IndexManifestEntry> readManifest(String indexManifest) {
        return this.indexManifestFile.read(indexManifest);
    }

    public List<IndexManifestEntry> readManifestWithIOException(String indexManifest) throws IOException {
        return this.indexManifestFile.readWithIOException(indexManifest);
    }

    private IndexFile indexFile(IndexFileMeta file) {
        switch (file.indexType()) {
            case "HASH": {
                return this.hashIndex;
            }
            case "DELETION_VECTORS": {
                return this.deletionVectorsIndex;
            }
        }
        throw new IllegalArgumentException("Unknown index type: " + file.indexType());
    }

    public boolean existsIndexFile(IndexManifestEntry file) {
        return this.indexFile(file.indexFile()).exists(file.indexFile().fileName());
    }

    public void deleteIndexFile(IndexManifestEntry file) {
        this.deleteIndexFile(file.indexFile());
    }

    public void deleteIndexFile(IndexFileMeta file) {
        this.indexFile(file).delete(file.fileName());
    }

    public void deleteManifest(String indexManifest) {
        this.indexManifestFile.delete(indexManifest);
    }

    public Map<String, DeletionVector> readAllDeletionVectors(List<IndexFileMeta> fileMetas) {
        for (IndexFileMeta indexFile : fileMetas) {
            Preconditions.checkArgument(indexFile.indexType().equals("DELETION_VECTORS"), "Input file is not deletion vectors index " + indexFile.indexType());
        }
        return this.deletionVectorsIndex.readAllDeletionVectors(fileMetas);
    }

    public List<IndexFileMeta> writeDeletionVectorsIndex(Map<String, DeletionVector> deletionVectors) {
        return this.deletionVectorsIndex.write(deletionVectors);
    }
}

