/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class RollbackProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("version", DataTypes.StringType), ProcedureParameter.optional("snapshot", DataTypes.LongType), ProcedureParameter.optional("tag", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    private RollbackProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        String version = args2.isNullAt(1) ? null : args2.getString(1);
        return this.modifyPaimonTable(tableIdent, table -> {
            Long snapshot = null;
            String tag = null;
            if (!StringUtils.isNullOrWhitespaceOnly(version)) {
                Preconditions.checkState(args2.isNullAt(2) && args2.isNullAt(3), "only can set one of version/snapshot/tag in RollbackProcedure.");
                if (version.chars().allMatch(Character::isDigit)) {
                    snapshot = Long.parseLong(version);
                } else {
                    tag = version;
                }
            } else {
                Preconditions.checkState(args2.isNullAt(2) && !args2.isNullAt(3) || !args2.isNullAt(2) && args2.isNullAt(3), "only can set one of version/snapshot/tag in RollbackProcedure.");
                snapshot = args2.isNullAt(2) ? null : Long.valueOf(args2.getLong(2));
                String string = tag = args2.isNullAt(3) ? null : args2.getString(3);
            }
            if (snapshot != null) {
                table.rollbackTo(snapshot);
            } else {
                table.rollbackTo(tag);
            }
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RollbackProcedure>(){

            @Override
            public RollbackProcedure doBuild() {
                return new RollbackProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RollbackProcedure";
    }
}

