/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class SimpleStatsEvolutions {
    private final Function<Long, List<DataField>> schemaFields;
    private final long tableSchemaId;
    private final List<DataField> tableDataFields;
    private final AtomicReference<List<DataField>> tableFields;
    private final ConcurrentMap<Long, SimpleStatsEvolution> evolutions;

    public SimpleStatsEvolutions(Function<Long, List<DataField>> schemaFields, long tableSchemaId) {
        this.schemaFields = schemaFields;
        this.tableSchemaId = tableSchemaId;
        this.tableDataFields = schemaFields.apply(tableSchemaId);
        this.tableFields = new AtomicReference();
        this.evolutions = new ConcurrentHashMap<Long, SimpleStatsEvolution>();
    }

    public SimpleStatsEvolution getOrCreate(long dataSchemaId) {
        return this.evolutions.computeIfAbsent(dataSchemaId, id -> {
            if (this.tableSchemaId == id) {
                return new SimpleStatsEvolution(new RowType(this.schemaFields.apply((Long)id)), null, null);
            }
            List<DataField> schemaTableFields = this.tableFields.updateAndGet(v -> v == null ? this.tableDataFields : v);
            List<DataField> dataFields = this.schemaFields.apply((Long)id);
            IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(schemaTableFields, this.schemaFields.apply((Long)id));
            int[] indexMapping = indexCastMapping.getIndexMapping();
            return new SimpleStatsEvolution(new RowType(dataFields), indexMapping, indexCastMapping.getCastMapping());
        });
    }

    @Nullable
    public Predicate tryDevolveFilter(long dataSchemaId, Predicate filter) {
        if (this.tableSchemaId == dataSchemaId) {
            return filter;
        }
        List<Predicate> devolved = Objects.requireNonNull(SchemaEvolutionUtil.devolveDataFilters(this.schemaFields.apply(this.tableSchemaId), this.schemaFields.apply(dataSchemaId), Collections.singletonList(filter)));
        return devolved.isEmpty() ? null : devolved.get(0);
    }

    public List<DataField> tableDataFields() {
        return this.tableDataFields;
    }
}

