/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.consumer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import org.apache.paimon.utils.JsonSerdeUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Consumer {
    private static final String FIELD_NEXT_SNAPSHOT = "nextSnapshot";
    private final long nextSnapshot;

    @JsonCreator
    public Consumer(@JsonProperty(value="nextSnapshot") long nextSnapshot) {
        this.nextSnapshot = nextSnapshot;
    }

    @JsonGetter(value="nextSnapshot")
    public long nextSnapshot() {
        return this.nextSnapshot;
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public static Consumer fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Consumer.class);
    }

    public static Optional<Consumer> fromPath(FileIO fileIO, Path path) {
        int retryNumber = 0;
        MismatchedInputException exception = null;
        while (retryNumber++ < 10) {
            try {
                return fileIO.readOverwrittenFileUtf8(path).map(Consumer::fromJson);
            }
            catch (MismatchedInputException e) {
                exception = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        throw new UncheckedIOException(exception);
    }
}

