/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class DeleteBranchProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("branch", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected DeleteBranchProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        org.apache.spark.sql.connector.catalog.Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        String branchStr = args2.getString(1);
        InternalRow[] result = this.modifyPaimonTable(tableIdent, table -> {
            table.deleteBranches(branchStr);
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
        ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog().invalidateTable(new Identifier(tableIdent.namespace()[0], tableIdent.name(), branchStr));
        return result;
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<DeleteBranchProcedure>(){

            @Override
            public DeleteBranchProcedure doBuild() {
                return new DeleteBranchProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "DeleteBranchProcedure";
    }
}

