/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sort;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.paimon.sort.zorder.ZOrderByteUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkZOrderUDF
implements Serializable {
    private static final byte[] PRIMITIVE_EMPTY = new byte[8];
    private transient ThreadLocal<ByteBuffer> outputBuffer;
    private transient ThreadLocal<byte[][]> inputHolder;
    private transient ThreadLocal<ByteBuffer[]> inputBuffers;
    private final int numCols;
    private int inputCol = 0;
    private int totalOutputBytes = 0;
    private final int varTypeSize;
    private final int maxOutputSize;
    private final UserDefinedFunction interleaveUDF = functions.udf((UDF1 & Serializable)arrayBinary -> this.interleaveBits((Seq<byte[]>)arrayBinary), (DataType)DataTypes.BinaryType).withName("INTERLEAVE_BYTES");

    public SparkZOrderUDF(int numCols, int varTypeSize, int maxOutputSize) {
        this.numCols = numCols;
        this.varTypeSize = varTypeSize;
        this.maxOutputSize = maxOutputSize;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.inputBuffers = ThreadLocal.withInitial(() -> new ByteBuffer[this.numCols]);
        this.inputHolder = ThreadLocal.withInitial(() -> new byte[this.numCols][]);
        this.outputBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(this.totalOutputBytes));
    }

    private ByteBuffer inputBuffer(int position, int size) {
        ByteBuffer buffer = this.inputBuffers.get()[position];
        if (buffer == null) {
            this.inputBuffers.get()[position] = buffer = ByteBuffer.allocate(size);
        }
        return buffer;
    }

    byte[] interleaveBits(Seq<byte[]> scalaBinary) {
        byte[][] columnsBinary = (byte[][])JavaConverters.seqAsJavaList(scalaBinary).toArray((Object[])this.inputHolder.get());
        return ZOrderByteUtils.interleaveBits(columnsBinary, this.totalOutputBytes, this.outputBuffer.get());
    }

    private UserDefinedFunction tinyToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return PRIMITIVE_EMPTY;
            }
            return ZOrderByteUtils.tinyintToOrderedBytes(value, this.inputBuffer(position, 8)).array();
        }, (DataType)DataTypes.BinaryType).withName("TINY_ORDERED_BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction shortToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return PRIMITIVE_EMPTY;
            }
            return ZOrderByteUtils.shortToOrderedBytes(value, this.inputBuffer(position, 8)).array();
        }, (DataType)DataTypes.BinaryType).withName("SHORT_ORDERED_BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction intToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return PRIMITIVE_EMPTY;
            }
            return ZOrderByteUtils.intToOrderedBytes(value, this.inputBuffer(position, 8)).array();
        }, (DataType)DataTypes.BinaryType).withName("INT_ORDERED_BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction longToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return PRIMITIVE_EMPTY;
            }
            return ZOrderByteUtils.longToOrderedBytes(value, this.inputBuffer(position, 8)).array();
        }, (DataType)DataTypes.BinaryType).withName("LONG_ORDERED_BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction floatToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return PRIMITIVE_EMPTY;
            }
            return ZOrderByteUtils.floatToOrderedBytes(value.floatValue(), this.inputBuffer(position, 8)).array();
        }, (DataType)DataTypes.BinaryType).withName("FLOAT_ORDERED_BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction doubleToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            if (value == null) {
                return PRIMITIVE_EMPTY;
            }
            return ZOrderByteUtils.doubleToOrderedBytes(value, this.inputBuffer(position, 8)).array();
        }, (DataType)DataTypes.BinaryType).withName("DOUBLE_ORDERED_BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction booleanToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> {
            ByteBuffer buffer = this.inputBuffer(position, 8);
            buffer.put(0, (byte)(value != false ? -127 : 0));
            return buffer.array();
        }, (DataType)DataTypes.BinaryType).withName("BOOLEAN-LEXICAL-BYTES");
        this.increaseOutputSize(8);
        return udf;
    }

    private UserDefinedFunction stringToOrderedBytesUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> ZOrderByteUtils.stringToOrderedBytes(value, this.varTypeSize, this.inputBuffer(position, this.varTypeSize)).array(), (DataType)DataTypes.BinaryType).withName("STRING-LEXICAL-BYTES");
        this.increaseOutputSize(this.varTypeSize);
        return udf;
    }

    private UserDefinedFunction bytesTruncateUDF() {
        int position = this.inputCol++;
        UserDefinedFunction udf = functions.udf((UDF1 & Serializable)value -> ZOrderByteUtils.byteTruncateOrFill(value, this.varTypeSize, this.inputBuffer(position, this.varTypeSize)).array(), (DataType)DataTypes.BinaryType).withName("BYTE-TRUNCATE");
        this.increaseOutputSize(this.varTypeSize);
        return udf;
    }

    public Column interleaveBytes(Column arrayBinary) {
        return this.interleaveUDF.apply(new Column[]{arrayBinary});
    }

    public Column sortedLexicographically(Column column, DataType type) {
        if (type instanceof ByteType) {
            return this.tinyToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof ShortType) {
            return this.shortToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof IntegerType) {
            return this.intToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof LongType) {
            return this.longToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof FloatType) {
            return this.floatToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof DoubleType) {
            return this.doubleToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof StringType) {
            return this.stringToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof BinaryType) {
            return this.bytesTruncateUDF().apply(new Column[]{column});
        }
        if (type instanceof BooleanType) {
            return this.booleanToOrderedBytesUDF().apply(new Column[]{column});
        }
        if (type instanceof TimestampType) {
            return this.longToOrderedBytesUDF().apply(new Column[]{column.cast(DataTypes.LongType)});
        }
        if (type instanceof DateType) {
            return this.longToOrderedBytesUDF().apply(new Column[]{column.cast(DataTypes.LongType)});
        }
        throw new IllegalArgumentException(String.format("Cannot use column %s of type %s in ZOrdering, the type is unsupported", column, type));
    }

    private void increaseOutputSize(int bytes) {
        this.totalOutputBytes = Math.min(this.totalOutputBytes + bytes, this.maxOutputSize);
    }
}

