/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.function.Function;
import org.apache.paimon.data.Segments;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.MoreExecutors;

public class SegmentsCache<T> {
    private static final int OBJECT_MEMORY_SIZE = 1000;
    private final int pageSize;
    private final Cache<T, Segments> cache;

    public SegmentsCache(int pageSize, MemorySize maxMemorySize) {
        this.pageSize = pageSize;
        this.cache = Caffeine.newBuilder().weigher(this::weigh).maximumWeight(maxMemorySize.getBytes()).executor(MoreExecutors.directExecutor()).build();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public Segments getSegments(T key, Function<T, Segments> viewFunction) {
        return this.cache.get(key, viewFunction);
    }

    private int weigh(T cacheKey, Segments segments) {
        return 1000 + segments.segments().size() * this.pageSize;
    }
}

