/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.nio.file.Path;
import java.util.List;
import org.apache.paimon.spark.SparkGenericCatalog;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SparkGenericCatalogTest {
    protected SparkSession spark = null;
    protected org.apache.paimon.fs.Path warehousePath = null;

    @BeforeEach
    public void startMetastoreAndSpark(@TempDir Path tempDir) {
        this.warehousePath = new org.apache.paimon.fs.Path("file:" + tempDir.toString());
        this.spark = SparkSession.builder().config("spark.sql.warehouse.dir", this.warehousePath.toString()).master("local[2]").getOrCreate();
        this.spark.conf().set("spark.sql.catalog.spark_catalog", SparkGenericCatalog.class.getName());
    }

    @AfterEach
    public void stopMetastoreAndSpark() {
        if (this.spark != null) {
            this.spark.stop();
            this.spark = null;
        }
    }

    @Test
    public void testPaimonTable() {
        this.spark.sql("CREATE TABLE PT (a INT, b INT, c STRING) USING paimon TBLPROPERTIES ('file.format'='avro')");
        this.testReadWrite("PT");
        this.spark.sql("CREATE DATABASE my_db");
        this.spark.sql("CREATE TABLE DB_PT (a INT, b INT, c STRING) USING paimon TBLPROPERTIES ('file.format'='avro')");
        this.testReadWrite("DB_PT");
        Assertions.assertThat(this.spark.sql("SHOW NAMESPACES").collectAsList().stream().map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[default]", "[my_db]"});
    }

    @Test
    public void testSparkSessionReload() {
        this.spark.sql("CREATE DATABASE my_db");
        this.spark.close();
        this.spark = SparkSession.builder().config("spark.sql.warehouse.dir", this.warehousePath.toString()).master("local[2]").getOrCreate();
        this.spark.conf().set("spark.sql.catalog.spark_catalog", SparkGenericCatalog.class.getName());
        Assertions.assertThatCode(() -> this.spark.sql("CREATE TABLE my_db.DB_PT (a INT, b INT, c STRING) USING paimon TBLPROPERTIES ('file.format'='avro')")).doesNotThrowAnyException();
    }

    @Test
    public void testCsvTable() {
        this.spark.sql("CREATE TABLE CT (a INT, b INT, c STRING) USING csv");
        this.testReadWrite("CT");
    }

    @Test
    public void testStructTable() {
        this.spark.sql("CREATE TABLE ST (a INT, b STRUCT<b1: STRING, b2: STRING, b3: STRING>) USING paimon");
    }

    private void testReadWrite(String table) {
        this.spark.sql("INSERT INTO " + table + " VALUES (1, 2, '3'), (4, 5, '6')").collectAsList();
        List rows = this.spark.sql("SELECT * FROM " + table).collectAsList();
        Assertions.assertThat(rows.stream().map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[1,2,3]", "[4,5,6]"});
    }
}

