/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.spark.SparkInternalRow;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTypeTest;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;

public class SparkInternalRowTest {
    @Test
    public void test() {
        GenericRow rowData = GenericRow.of((Object[])new Object[]{1, BinaryString.fromString((String)"jingsong"), 22.2, new GenericMap(Stream.of(new AbstractMap.SimpleEntry<BinaryString, GenericRow>(BinaryString.fromString((String)"key1"), GenericRow.of((Object[])new Object[]{1.2, 2.3})), new AbstractMap.SimpleEntry<BinaryString, GenericRow>(BinaryString.fromString((String)"key2"), GenericRow.of((Object[])new Object[]{2.4, 3.5}))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), new GenericArray((Object[])new BinaryString[]{BinaryString.fromString((String)"v1"), BinaryString.fromString((String)"v5")}), new GenericArray((Object[])new Integer[]{10, 30}), true, (byte)22, (short)356, 23567222L, "varbinary_v".getBytes(StandardCharsets.UTF_8), Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2007-12-03T10:15:30")), DateTimeUtils.toInternal((LocalDate)LocalDate.parse("2022-05-02")), Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(0.21), (int)2, (int)2), Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.578212312301E10), (int)38, (int)2), Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.21231235E7), (int)10, (int)1)});
        Function1 sparkConverter = CatalystTypeConverters.createToScalaConverter((org.apache.spark.sql.types.DataType)SparkTypeUtils.fromPaimonType((DataType)SparkTypeTest.ALL_TYPES));
        Row sparkRow = (Row)sparkConverter.apply((Object)new SparkInternalRow(SparkTypeTest.ALL_TYPES).replace((InternalRow)rowData));
        String expected = "{\"id\":1,\"name\":\"jingsong\",\"salary\":22.2,\"locations\":{\"key1\":{\"posX\":1.2,\"posY\":2.3},\"key2\":{\"posX\":2.4,\"posY\":3.5}},\"strArray\":[\"v1\",\"v5\"],\"intArray\":[10,30],\"boolean\":true,\"tinyint\":22,\"smallint\":356,\"bigint\":23567222,\"bytes\":\"dmFyYmluYXJ5X3Y=\",\"timestamp\":\"2007-12-03 10:15:30\",\"date\":\"2022-05-02\",\"decimal\":0.21,\"decimal2\":65782123123.01,\"decimal3\":62123123.5}";
        Assertions.assertThat((String)sparkRow.json()).isEqualTo(expected);
        SparkRow sparkRowData = new SparkRow(SparkTypeTest.ALL_TYPES, sparkRow);
        sparkRow = (Row)sparkConverter.apply((Object)new SparkInternalRow(SparkTypeTest.ALL_TYPES).replace((InternalRow)sparkRowData));
        Assertions.assertThat((String)sparkRow.json()).isEqualTo(expected);
    }
}

