/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOTest;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.s3.MinioTestContainer;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.testutils.junit.parameterized.ParameterizedTestExtension;
import org.apache.paimon.testutils.junit.parameterized.Parameters;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SparkS3ITCase {
    @RegisterExtension
    public static final MinioTestContainer MINIO_CONTAINER = new MinioTestContainer();
    private static Path warehousePath;
    private static SparkSession spark;
    private final String format;

    @BeforeAll
    public static void startMetastoreAndSpark() {
        String path = MINIO_CONTAINER.getS3UriForDefaultBucket() + "/" + UUID.randomUUID();
        warehousePath = new Path(path);
        spark = SparkSession.builder().master("local[2]").getOrCreate();
        spark.conf().set("spark.sql.catalog.paimon", SparkCatalog.class.getName());
        spark.conf().set("spark.sql.catalog.paimon.warehouse", warehousePath.toString());
        MINIO_CONTAINER.getS3ConfigOptions().forEach((k, v) -> spark.conf().set("spark.sql.catalog.paimon." + k, v));
        spark.sql("CREATE DATABASE paimon.db");
        spark.sql("USE paimon.db");
    }

    @AfterAll
    public static void stopMetastoreAndSpark() {
        if (spark != null) {
            spark.stop();
            spark = null;
        }
    }

    @Parameters(name="{0}")
    public static Collection<String> parameters() {
        return Arrays.asList("avro", "orc", "parquet");
    }

    public SparkS3ITCase(String format) {
        this.format = format;
    }

    @AfterEach
    public void afterEach() {
        spark.sql("DROP TABLE IF EXISTS T");
    }

    @TestTemplate
    public void testWriteRead() {
        spark.sql(String.format("CREATE TABLE T (a INT, b INT, c STRING) TBLPROPERTIES ('primary-key'='a', 'bucket'='4', 'file.format'='%s')", this.format));
        spark.sql("INSERT INTO T VALUES (1, 2, '3')").collectAsList();
        List rows = spark.sql("SELECT * FROM T").collectAsList();
        Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,2,3]]");
    }

    @TestTemplate
    public void testS3AtomicWriteMultipleThreads() throws InterruptedException, IOException {
        Path file = new Path(warehousePath, UUID.randomUUID().toString());
        Options options = new Options();
        MINIO_CONTAINER.getS3ConfigOptions().forEach((arg_0, arg_1) -> ((Options)options).setString(arg_0, arg_1));
        FileIO fileIO = FileIO.get((Path)file, (CatalogContext)CatalogContext.create((Options)options));
        FileIOTest.testOverwriteFileUtf8((Path)file, (FileIO)fileIO);
    }

    static {
        spark = null;
    }
}

